/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import org.springframework.data.cassandra.core.cql.ExecutionProfileResolver;
import org.springframework.data.cassandra.core.cql.QueryOptions;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class WriteOptions
extends QueryOptions {
    private static final WriteOptions EMPTY = new WriteOptionsBuilder().build();
    private final Duration ttl;
    @Nullable
    private final Long timestamp;

    protected WriteOptions(@Nullable ConsistencyLevel consistencyLevel, ExecutionProfileResolver executionProfileResolver, @Nullable Integer pageSize, @Nullable ConsistencyLevel serialConsistencyLevel, Duration timeout, Duration ttl, @Nullable Long timestamp, @Nullable Boolean tracing) {
        super(consistencyLevel, executionProfileResolver, pageSize, serialConsistencyLevel, timeout, tracing);
        this.ttl = ttl;
        this.timestamp = timestamp;
    }

    public static WriteOptions empty() {
        return EMPTY;
    }

    public static WriteOptionsBuilder builder() {
        return new WriteOptionsBuilder();
    }

    @Override
    public WriteOptionsBuilder mutate() {
        return new WriteOptionsBuilder(this);
    }

    public Duration getTtl() {
        return this.ttl;
    }

    @Nullable
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WriteOptions)) {
            return false;
        }
        WriteOptions other = (WriteOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Duration this$ttl = this.getTtl();
        Duration other$ttl = other.getTtl();
        if (this$ttl == null ? other$ttl != null : !((Object)this$ttl).equals(other$ttl)) {
            return false;
        }
        Long this$timestamp = this.getTimestamp();
        Long other$timestamp = other.getTimestamp();
        return !(this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof WriteOptions;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Duration $ttl = this.getTtl();
        result = result * 59 + ($ttl == null ? 43 : ((Object)$ttl).hashCode());
        Long $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        return result;
    }

    public static class WriteOptionsBuilder
    extends QueryOptions.QueryOptionsBuilder {
        protected Duration ttl = Duration.ofMillis(-1L);
        protected Long timestamp = null;

        protected WriteOptionsBuilder() {
        }

        protected WriteOptionsBuilder(WriteOptions writeOptions) {
            super(writeOptions);
            this.ttl = writeOptions.ttl;
            this.timestamp = writeOptions.timestamp;
        }

        @Override
        public WriteOptionsBuilder consistencyLevel(ConsistencyLevel consistencyLevel) {
            super.consistencyLevel(consistencyLevel);
            return this;
        }

        @Override
        public WriteOptionsBuilder executionProfile(String profileName) {
            super.executionProfile(profileName);
            return this;
        }

        @Override
        public WriteOptionsBuilder executionProfile(ExecutionProfileResolver executionProfileResolver) {
            super.executionProfile(executionProfileResolver);
            return this;
        }

        @Override
        @Deprecated
        public WriteOptionsBuilder fetchSize(int pageSize) {
            super.fetchSize(pageSize);
            return this;
        }

        @Override
        public WriteOptionsBuilder pageSize(int pageSize) {
            super.pageSize(pageSize);
            return this;
        }

        @Override
        @Deprecated
        public WriteOptionsBuilder readTimeout(long readTimeout) {
            super.readTimeout(readTimeout);
            return this;
        }

        @Override
        @Deprecated
        public WriteOptionsBuilder readTimeout(long readTimeout, TimeUnit timeUnit) {
            super.readTimeout(readTimeout, timeUnit);
            return this;
        }

        @Override
        public WriteOptionsBuilder serialConsistencyLevel(ConsistencyLevel consistencyLevel) {
            super.serialConsistencyLevel(consistencyLevel);
            return this;
        }

        @Override
        public WriteOptionsBuilder timeout(Duration timeout) {
            super.timeout(timeout);
            return this;
        }

        @Override
        public WriteOptionsBuilder tracing(boolean tracing) {
            super.tracing(tracing);
            return this;
        }

        @Override
        public WriteOptionsBuilder withTracing() {
            super.withTracing();
            return this;
        }

        public WriteOptionsBuilder ttl(int ttl) {
            Assert.isTrue((ttl >= 0 ? 1 : 0) != 0, (String)"TTL must be greater than equal to zero");
            this.ttl = Duration.ofSeconds(ttl);
            return this;
        }

        public WriteOptionsBuilder ttl(Duration ttl) {
            Assert.notNull((Object)ttl, (String)"TTL must not be null");
            Assert.isTrue((!ttl.isNegative() ? 1 : 0) != 0, (String)"TTL must be greater than equal to zero");
            this.ttl = ttl;
            return this;
        }

        public WriteOptionsBuilder timestamp(long timestamp) {
            Assert.isTrue((timestamp >= 0L ? 1 : 0) != 0, (String)"Timestamp must be greater than equal to zero");
            this.timestamp = timestamp;
            return this;
        }

        public WriteOptionsBuilder timestamp(Instant timestamp) {
            Assert.notNull((Object)timestamp, (String)"Timestamp must not be null");
            this.timestamp = TimeUnit.MILLISECONDS.toMicros(timestamp.toEpochMilli());
            return this;
        }

        @Override
        public WriteOptions build() {
            return new WriteOptions(this.consistencyLevel, this.executionProfileResolver, this.pageSize, this.serialConsistencyLevel, this.timeout, this.ttl, this.timestamp, this.tracing);
        }
    }
}

