/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.cassandra.core.StatementFactory;
import org.springframework.data.cassandra.core.cql.QueryExtractorDelegate;
import org.springframework.data.cassandra.core.cql.QueryOptions;
import org.springframework.data.cassandra.core.cql.QueryOptionsUtil;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.query.Columns;
import org.springframework.data.cassandra.repository.Query;
import org.springframework.data.cassandra.repository.query.CassandraParameterAccessor;
import org.springframework.data.cassandra.repository.query.CassandraQueryCreator;
import org.springframework.data.cassandra.repository.query.CassandraQueryMethod;
import org.springframework.data.cassandra.repository.query.StringBasedQuery;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.QueryCreationException;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.query.parser.PartTree;

class QueryStatementCreator {
    private static final Logger LOG = LoggerFactory.getLogger(QueryStatementCreator.class);
    private final CassandraQueryMethod queryMethod;
    private final MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> mappingContext;

    private CassandraPersistentEntity<?> getPersistentEntity() {
        return (CassandraPersistentEntity)this.mappingContext.getRequiredPersistentEntity(this.queryMethod.getDomainClass());
    }

    SimpleStatement select(StatementFactory statementFactory, PartTree tree, CassandraParameterAccessor parameterAccessor, ResultProcessor processor) {
        Function<org.springframework.data.cassandra.core.query.Query, SimpleStatement> function = query2 -> {
            ReturnedType returnedType = processor.withDynamicProjection((ParameterAccessor)parameterAccessor).getReturnedType();
            if (returnedType.needsCustomConstruction()) {
                Columns columns = Columns.from(returnedType.getInputProperties().toArray(new String[0]));
                query2 = query2.columns(columns);
            }
            SimpleStatement statement = statementFactory.select((org.springframework.data.cassandra.core.query.Query)query2, this.getPersistentEntity()).build();
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Created query [%s].", statement));
            }
            return statement;
        };
        return this.doWithQuery(parameterAccessor, tree, function);
    }

    SimpleStatement count(StatementFactory statementFactory, PartTree tree, CassandraParameterAccessor parameterAccessor) {
        Function<org.springframework.data.cassandra.core.query.Query, SimpleStatement> function = query2 -> {
            SimpleStatement statement = statementFactory.count((org.springframework.data.cassandra.core.query.Query)query2, this.getPersistentEntity()).build();
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Created query [%s].", QueryExtractorDelegate.getCql(statement)));
            }
            return statement;
        };
        return this.doWithQuery(parameterAccessor, tree, function);
    }

    SimpleStatement delete(StatementFactory statementFactory, PartTree tree, CassandraParameterAccessor parameterAccessor) {
        Function<org.springframework.data.cassandra.core.query.Query, SimpleStatement> function = query2 -> {
            SimpleStatement statement = statementFactory.delete((org.springframework.data.cassandra.core.query.Query)query2, this.getPersistentEntity()).build();
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Created query [%s].", QueryExtractorDelegate.getCql(statement)));
            }
            return statement;
        };
        return this.doWithQuery(parameterAccessor, tree, function);
    }

    SimpleStatement exists(StatementFactory statementFactory, PartTree tree, CassandraParameterAccessor parameterAccessor) {
        Function<org.springframework.data.cassandra.core.query.Query, SimpleStatement> function = query2 -> {
            SimpleStatement statement = statementFactory.select(query2.limit(1L), this.getPersistentEntity()).build();
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Created query [%s].", QueryExtractorDelegate.getCql(statement)));
            }
            return statement;
        };
        return this.doWithQuery(parameterAccessor, tree, function);
    }

    <T> T doWithQuery(CassandraParameterAccessor parameterAccessor, PartTree tree, Function<org.springframework.data.cassandra.core.query.Query, ? extends T> function) {
        CassandraQueryCreator queryCreator = new CassandraQueryCreator(tree, parameterAccessor, this.mappingContext);
        org.springframework.data.cassandra.core.query.Query query2 = (org.springframework.data.cassandra.core.query.Query)queryCreator.createQuery();
        try {
            Optional<QueryOptions> queryOptions;
            if (tree.isLimiting()) {
                query2 = query2.limit(tree.getMaxResults().intValue());
            }
            if (this.allowsFiltering()) {
                query2 = query2.withAllowFiltering();
            }
            if ((queryOptions = Optional.ofNullable(parameterAccessor.getQueryOptions())).isPresent()) {
                query2 = Optional.ofNullable(parameterAccessor.getQueryOptions()).map(query2::queryOptions).orElse(query2);
            } else if (this.queryMethod.hasConsistencyLevel()) {
                query2 = query2.queryOptions(QueryOptions.builder().consistencyLevel(this.queryMethod.getRequiredAnnotatedConsistencyLevel()).build());
            }
            return function.apply(query2);
        }
        catch (RuntimeException cause) {
            throw QueryCreationException.create((QueryMethod)this.queryMethod, (Throwable)cause);
        }
    }

    private boolean allowsFiltering() {
        return this.queryMethod.getQueryAnnotation().map(Query::allowFiltering).orElse(false);
    }

    SimpleStatement select(StringBasedQuery stringBasedQuery, CassandraParameterAccessor parameterAccessor) {
        try {
            SimpleStatement boundQuery = stringBasedQuery.bindQuery(parameterAccessor, this.queryMethod);
            Optional<QueryOptions> queryOptions = Optional.ofNullable(parameterAccessor.getQueryOptions());
            SimpleStatement queryToUse = boundQuery;
            if (queryOptions.isPresent()) {
                queryToUse = Optional.ofNullable(parameterAccessor.getQueryOptions()).map(it -> QueryOptionsUtil.addQueryOptions(boundQuery, it)).orElse(boundQuery);
            } else if (this.queryMethod.hasConsistencyLevel()) {
                queryToUse = (SimpleStatement)queryToUse.setConsistencyLevel(this.queryMethod.getRequiredAnnotatedConsistencyLevel());
            }
            Query.Idempotency idempotency = this.queryMethod.getIdempotency();
            if (idempotency != Query.Idempotency.UNDEFINED) {
                queryToUse = (SimpleStatement)queryToUse.setIdempotent(Boolean.valueOf(idempotency == Query.Idempotency.IDEMPOTENT));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Created query [%s].", QueryExtractorDelegate.getCql(queryToUse)));
            }
            return queryToUse;
        }
        catch (RuntimeException cause) {
            throw QueryCreationException.create((QueryMethod)this.queryMethod, (Throwable)cause);
        }
    }

    public QueryStatementCreator(CassandraQueryMethod queryMethod, MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> mappingContext) {
        this.queryMethod = queryMethod;
        this.mappingContext = mappingContext;
    }
}

