/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.query;

import java.util.Arrays;
import java.util.Collection;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.cassandra.core.query.ColumnName;
import org.springframework.data.cassandra.core.query.CriteriaDefinition;
import org.springframework.data.cassandra.core.query.SerializationUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class Criteria
implements CriteriaDefinition {
    private final ColumnName columnName;
    @Nullable
    private CriteriaDefinition.Predicate predicate;

    private Criteria(ColumnName columnName, CriteriaDefinition.Predicate predicate) {
        this(columnName);
        Assert.notNull((Object)predicate, (String)"Predicate must not be null");
        this.predicate = predicate;
    }

    protected Criteria(ColumnName columnName) {
        Assert.notNull((Object)columnName, (String)"ColumnName must not be null");
        this.columnName = columnName;
    }

    public static Criteria where(String columnName) {
        return Criteria.where(ColumnName.from(columnName));
    }

    public static Criteria where(ColumnName columnName) {
        Assert.notNull((Object)columnName, (String)"ColumnName must not be null");
        return new Criteria(columnName);
    }

    public static Criteria of(ColumnName columnName, CriteriaDefinition.Predicate predicate) {
        Assert.notNull((Object)columnName, (String)"ColumnName must not be null");
        Assert.notNull((Object)predicate, (String)"Predicate must not be null");
        return new Criteria(columnName, predicate);
    }

    public CriteriaDefinition is(@Nullable Object value) {
        this.predicate = new CriteriaDefinition.Predicate(CriteriaDefinition.Operators.EQ, value);
        return this;
    }

    public CriteriaDefinition ne(@Nullable Object value) {
        this.predicate = new CriteriaDefinition.Predicate(CriteriaDefinition.Operators.NE, value);
        return this;
    }

    public CriteriaDefinition isNotNull() {
        this.predicate = new CriteriaDefinition.Predicate(CriteriaDefinition.Operators.IS_NOT_NULL, null);
        return this;
    }

    public CriteriaDefinition lt(Object value) {
        Assert.notNull((Object)value, (String)"Value must not be null");
        this.predicate = new CriteriaDefinition.Predicate(CriteriaDefinition.Operators.LT, value);
        return this;
    }

    public CriteriaDefinition lte(Object value) {
        Assert.notNull((Object)value, (String)"Value must not be null");
        this.predicate = new CriteriaDefinition.Predicate(CriteriaDefinition.Operators.LTE, value);
        return this;
    }

    public CriteriaDefinition gt(Object value) {
        Assert.notNull((Object)value, (String)"Value must not be null");
        this.predicate = new CriteriaDefinition.Predicate(CriteriaDefinition.Operators.GT, value);
        return this;
    }

    public CriteriaDefinition gte(Object value) {
        Assert.notNull((Object)value, (String)"Value must not be null");
        this.predicate = new CriteriaDefinition.Predicate(CriteriaDefinition.Operators.GTE, value);
        return this;
    }

    public CriteriaDefinition in(Object ... values) {
        Assert.notNull((Object)values, (String)"Value must not be null");
        if (values.length > 1 && values[1] instanceof Collection) {
            throw new InvalidDataAccessApiUsageException("You can only pass in one argument of type " + values[1].getClass().getName());
        }
        return this.in(Arrays.asList(values));
    }

    public CriteriaDefinition in(Collection<?> values) {
        Assert.notNull(values, (String)"Value must not be null");
        this.predicate = new CriteriaDefinition.Predicate(CriteriaDefinition.Operators.IN, values);
        return this;
    }

    public CriteriaDefinition like(Object value) {
        Assert.notNull((Object)value, (String)"Value must not be null");
        this.predicate = new CriteriaDefinition.Predicate(CriteriaDefinition.Operators.LIKE, value);
        return this;
    }

    public CriteriaDefinition contains(Object value) {
        Assert.notNull((Object)value, (String)"Value must not be null");
        this.predicate = new CriteriaDefinition.Predicate(CriteriaDefinition.Operators.CONTAINS, value);
        return this;
    }

    public CriteriaDefinition containsKey(Object key) {
        Assert.notNull((Object)key, (String)"Value must not be null");
        this.predicate = new CriteriaDefinition.Predicate(CriteriaDefinition.Operators.CONTAINS_KEY, key);
        return this;
    }

    @Override
    public ColumnName getColumnName() {
        return this.columnName;
    }

    @Override
    public CriteriaDefinition.Predicate getPredicate() {
        return this.predicate;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Criteria)) {
            return false;
        }
        Criteria that = (Criteria)obj;
        return this.simpleCriteriaEquals(this, that);
    }

    protected boolean simpleCriteriaEquals(CriteriaDefinition left, CriteriaDefinition right) {
        boolean keyEqual = left.getColumnName().equals(right.getColumnName());
        boolean criteriaEqual = left.getPredicate().equals(right.getPredicate());
        return keyEqual && criteriaEqual;
    }

    public int hashCode() {
        int result = 17;
        result += ObjectUtils.nullSafeHashCode((Object)this.columnName);
        return result += ObjectUtils.nullSafeHashCode((Object)this.predicate);
    }

    public String toString() {
        return SerializationUtils.serializeToCqlSafely(this);
    }
}

