/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.springframework.data.cassandra.core.cql.ExecutionProfileResolver;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class QueryOptions {
    private static final QueryOptions EMPTY = QueryOptions.builder().build();
    @Nullable
    private final ConsistencyLevel consistencyLevel;
    private final ExecutionProfileResolver executionProfileResolver;
    @Nullable
    private final Integer pageSize;
    @Nullable
    private final ConsistencyLevel serialConsistencyLevel;
    private final Duration timeout;
    @Nullable
    private final Boolean tracing;

    protected QueryOptions(@Nullable ConsistencyLevel consistencyLevel, ExecutionProfileResolver executionProfileResolver, @Nullable Integer pageSize, @Nullable ConsistencyLevel serialConsistencyLevel, Duration timeout, @Nullable Boolean tracing) {
        this.consistencyLevel = consistencyLevel;
        this.executionProfileResolver = executionProfileResolver;
        this.pageSize = pageSize;
        this.serialConsistencyLevel = serialConsistencyLevel;
        this.timeout = timeout;
        this.tracing = tracing;
    }

    public static QueryOptionsBuilder builder() {
        return new QueryOptionsBuilder();
    }

    public static QueryOptions empty() {
        return EMPTY;
    }

    public QueryOptionsBuilder mutate() {
        return new QueryOptionsBuilder(this);
    }

    @Nullable
    protected ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    protected ExecutionProfileResolver getExecutionProfileResolver() {
        return this.executionProfileResolver;
    }

    @Nullable
    protected Integer getPageSize() {
        return this.pageSize;
    }

    @Deprecated
    protected Duration getReadTimeout() {
        return this.getTimeout();
    }

    protected Duration getTimeout() {
        return this.timeout;
    }

    @Nullable
    protected ConsistencyLevel getSerialConsistencyLevel() {
        return this.serialConsistencyLevel;
    }

    @Nullable
    protected Boolean getTracing() {
        return this.tracing;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryOptions)) {
            return false;
        }
        QueryOptions other = (QueryOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ConsistencyLevel this$consistencyLevel = this.getConsistencyLevel();
        ConsistencyLevel other$consistencyLevel = other.getConsistencyLevel();
        if (this$consistencyLevel == null ? other$consistencyLevel != null : !this$consistencyLevel.equals(other$consistencyLevel)) {
            return false;
        }
        ExecutionProfileResolver this$executionProfileResolver = this.getExecutionProfileResolver();
        ExecutionProfileResolver other$executionProfileResolver = other.getExecutionProfileResolver();
        if (this$executionProfileResolver == null ? other$executionProfileResolver != null : !this$executionProfileResolver.equals(other$executionProfileResolver)) {
            return false;
        }
        Integer this$pageSize = this.getPageSize();
        Integer other$pageSize = other.getPageSize();
        if (this$pageSize == null ? other$pageSize != null : !((Object)this$pageSize).equals(other$pageSize)) {
            return false;
        }
        ConsistencyLevel this$serialConsistencyLevel = this.getSerialConsistencyLevel();
        ConsistencyLevel other$serialConsistencyLevel = other.getSerialConsistencyLevel();
        if (this$serialConsistencyLevel == null ? other$serialConsistencyLevel != null : !this$serialConsistencyLevel.equals(other$serialConsistencyLevel)) {
            return false;
        }
        Duration this$timeout = this.getTimeout();
        Duration other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
            return false;
        }
        Boolean this$tracing = this.getTracing();
        Boolean other$tracing = other.getTracing();
        return !(this$tracing == null ? other$tracing != null : !((Object)this$tracing).equals(other$tracing));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QueryOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConsistencyLevel $consistencyLevel = this.getConsistencyLevel();
        result = result * 59 + ($consistencyLevel == null ? 43 : $consistencyLevel.hashCode());
        ExecutionProfileResolver $executionProfileResolver = this.getExecutionProfileResolver();
        result = result * 59 + ($executionProfileResolver == null ? 43 : $executionProfileResolver.hashCode());
        Integer $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : ((Object)$pageSize).hashCode());
        ConsistencyLevel $serialConsistencyLevel = this.getSerialConsistencyLevel();
        result = result * 59 + ($serialConsistencyLevel == null ? 43 : $serialConsistencyLevel.hashCode());
        Duration $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        Boolean $tracing = this.getTracing();
        result = result * 59 + ($tracing == null ? 43 : ((Object)$tracing).hashCode());
        return result;
    }

    public static class QueryOptionsBuilder {
        @Nullable
        protected ConsistencyLevel consistencyLevel;
        protected ExecutionProfileResolver executionProfileResolver = ExecutionProfileResolver.none();
        @Nullable
        protected Integer pageSize;
        @Nullable
        protected ConsistencyLevel serialConsistencyLevel;
        protected Duration timeout = Duration.ofMillis(-1L);
        @Nullable
        protected Boolean tracing;

        QueryOptionsBuilder() {
        }

        QueryOptionsBuilder(QueryOptions queryOptions) {
            this.consistencyLevel = queryOptions.consistencyLevel;
            this.executionProfileResolver = queryOptions.executionProfileResolver;
            this.pageSize = queryOptions.pageSize;
            this.serialConsistencyLevel = queryOptions.serialConsistencyLevel;
            this.timeout = queryOptions.timeout;
            this.tracing = queryOptions.tracing;
        }

        public QueryOptionsBuilder consistencyLevel(ConsistencyLevel consistencyLevel) {
            Assert.notNull((Object)consistencyLevel, (String)"ConsistencyLevel must not be null");
            this.consistencyLevel = consistencyLevel;
            return this;
        }

        public QueryOptionsBuilder executionProfile(String profileName) {
            return this.executionProfile(ExecutionProfileResolver.from(profileName));
        }

        public QueryOptionsBuilder executionProfile(ExecutionProfileResolver executionProfileResolver) {
            Assert.notNull((Object)executionProfileResolver, (String)"ExecutionProfileResolver must not be null");
            this.executionProfileResolver = executionProfileResolver;
            return this;
        }

        @Deprecated
        public QueryOptionsBuilder fetchSize(int fetchSize) {
            return this.pageSize(fetchSize);
        }

        public QueryOptionsBuilder pageSize(int pageSize) {
            Assert.isTrue((pageSize >= 0 ? 1 : 0) != 0, (String)"Page size must be greater than equal to zero");
            this.pageSize = pageSize;
            return this;
        }

        @Deprecated
        public QueryOptionsBuilder readTimeout(long readTimeout) {
            return this.timeout(Duration.ofMillis(readTimeout));
        }

        @Deprecated
        public QueryOptionsBuilder readTimeout(long readTimeout, TimeUnit timeUnit) {
            Assert.isTrue((readTimeout >= 0L ? 1 : 0) != 0, (String)"ReadTimeout must be greater than equal to zero");
            Assert.notNull((Object)((Object)timeUnit), (String)"TimeUnit must not be null");
            return this.timeout(Duration.ofMillis(timeUnit.toMillis(readTimeout)));
        }

        @Deprecated
        public QueryOptionsBuilder readTimeout(Duration readTimeout) {
            Assert.isTrue((!readTimeout.isZero() && !readTimeout.isNegative() ? 1 : 0) != 0, (String)"ReadTimeout must be greater than equal to zero");
            this.timeout = readTimeout;
            return this;
        }

        public QueryOptionsBuilder serialConsistencyLevel(ConsistencyLevel consistencyLevel) {
            Assert.notNull((Object)consistencyLevel, (String)"Serial ConsistencyLevel must not be null");
            this.serialConsistencyLevel = consistencyLevel;
            return this;
        }

        public QueryOptionsBuilder timeout(Duration timeout) {
            Assert.isTrue((!timeout.isZero() && !timeout.isNegative() ? 1 : 0) != 0, (String)"ReadTimeout must be greater than equal to zero");
            this.timeout = timeout;
            return this;
        }

        public QueryOptionsBuilder tracing(boolean tracing) {
            this.tracing = tracing;
            return this;
        }

        public QueryOptionsBuilder withTracing() {
            return this.tracing(true);
        }

        public QueryOptions build() {
            return new QueryOptions(this.consistencyLevel, this.executionProfileResolver, this.pageSize, this.serialConsistencyLevel, this.timeout, this.tracing);
        }
    }
}

