/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.ResultSet;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Optional;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.repository.Consistency;
import org.springframework.data.cassandra.repository.Query;
import org.springframework.data.cassandra.repository.query.CassandraEntityMetadata;
import org.springframework.data.cassandra.repository.query.CassandraParameters;
import org.springframework.data.cassandra.repository.query.SimpleCassandraEntityMetadata;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class CassandraQueryMethod
extends QueryMethod {
    private final Method method;
    private final MappingContext<? extends CassandraPersistentEntity<?>, ? extends CassandraPersistentProperty> mappingContext;
    private final Optional<Query> query;
    private final Optional<Consistency> consistency;
    @Nullable
    private CassandraEntityMetadata<?> entityMetadata;

    public CassandraQueryMethod(Method method, RepositoryMetadata repositoryMetadata, ProjectionFactory projectionFactory, MappingContext<? extends CassandraPersistentEntity<?>, ? extends CassandraPersistentProperty> mappingContext) {
        super(method, repositoryMetadata, projectionFactory);
        Assert.notNull(mappingContext, (String)"MappingContext must not be null");
        this.verify(method, repositoryMetadata);
        this.method = method;
        this.mappingContext = mappingContext;
        this.query = Optional.ofNullable(AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Query.class));
        this.consistency = Optional.ofNullable(AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Consistency.class));
    }

    public void verify(Method method, RepositoryMetadata metadata) {
        if (this.isPageQuery()) {
            throw new InvalidDataAccessApiUsageException("Page queries are not supported. Use a Slice query.");
        }
    }

    public CassandraEntityMetadata<?> getEntityInformation() {
        if (this.entityMetadata == null) {
            Class returnedObjectType = this.getReturnedObjectType();
            Class<?> domainClass = this.getDomainClass();
            if (ClassUtils.isPrimitiveOrWrapper((Class)returnedObjectType)) {
                this.entityMetadata = new SimpleCassandraEntityMetadata(domainClass, (CassandraPersistentEntity)this.mappingContext.getRequiredPersistentEntity(domainClass));
            } else {
                CassandraPersistentEntity returnedEntity = (CassandraPersistentEntity)this.mappingContext.getPersistentEntity(returnedObjectType);
                CassandraPersistentEntity managedEntity = (CassandraPersistentEntity)this.mappingContext.getRequiredPersistentEntity(domainClass);
                returnedEntity = returnedEntity == null || returnedEntity.getType().isInterface() ? managedEntity : returnedEntity;
                this.entityMetadata = new SimpleCassandraEntityMetadata(returnedEntity.getType(), managedEntity);
            }
        }
        return this.entityMetadata;
    }

    public CassandraParameters getParameters() {
        return (CassandraParameters)super.getParameters();
    }

    protected CassandraParameters createParameters(Method method) {
        return new CassandraParameters(method);
    }

    public boolean hasAnnotatedQuery() {
        return this.query.map(Query::value).filter(StringUtils::hasText).isPresent();
    }

    @Nullable
    public String getAnnotatedQuery() {
        return this.query.map(Query::value).orElse(null);
    }

    public boolean hasConsistencyLevel() {
        return this.consistency.isPresent();
    }

    public ConsistencyLevel getRequiredAnnotatedConsistencyLevel() throws IllegalStateException {
        return this.consistency.map(Consistency::value).orElseThrow(() -> new IllegalStateException("No @Consistency annotation found"));
    }

    public String getRequiredAnnotatedQuery() {
        return this.query.map(Query::value).orElseThrow(() -> new IllegalStateException("Query method " + (Object)((Object)this) + " has no annotated query"));
    }

    Optional<Query> getQueryAnnotation() {
        return this.query;
    }

    protected Class<?> getDomainClass() {
        return super.getDomainClass();
    }

    public TypeInformation<?> getReturnType() {
        return ClassTypeInformation.fromReturnTypeOf((Method)this.method);
    }

    public boolean isResultSetQuery() {
        TypeInformation actualType = this.getReturnType().getActualType();
        return actualType != null && ResultSet.class.isAssignableFrom(actualType.getType());
    }

    Query.Idempotency getIdempotency() {
        return this.query.filter(it -> it.idempotent() != Query.Idempotency.UNDEFINED).map(Query::idempotent).orElseGet(() -> {
            String cql = this.getAnnotatedQuery();
            if (StringUtils.hasText((String)cql) && cql.trim().toUpperCase(Locale.ENGLISH).startsWith("SELECT ")) {
                return Query.Idempotency.IDEMPOTENT;
            }
            return Query.Idempotency.UNDEFINED;
        });
    }
}

