/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.mapping;

import org.springframework.data.cassandra.core.cql.CqlIdentifier;
import org.springframework.data.cassandra.core.mapping.BasicCassandraPersistentProperty;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.Element;
import org.springframework.data.cassandra.core.mapping.UserTypeResolver;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class BasicCassandraPersistentTupleProperty
extends BasicCassandraPersistentProperty {
    @Nullable
    private final Integer ordinal = this.findOrdinal();

    public BasicCassandraPersistentTupleProperty(Property property, CassandraPersistentEntity<?> owner, SimpleTypeHolder simpleTypeHolder) {
        this(property, owner, simpleTypeHolder, null);
    }

    public BasicCassandraPersistentTupleProperty(Property property, CassandraPersistentEntity<?> owner, SimpleTypeHolder simpleTypeHolder, @Nullable UserTypeResolver userTypeResolver) {
        super(property, owner, simpleTypeHolder, userTypeResolver);
    }

    @Nullable
    private Integer findOrdinal() {
        int ordinal;
        if (this.isTransient()) {
            return null;
        }
        try {
            ordinal = ((Element)this.getRequiredAnnotation(Element.class)).value();
        }
        catch (IllegalStateException cause) {
            throw new MappingException(String.format("Missing @Element annotation in mapped tuple type for property [%s] in entity [%s]", this.getName(), this.getOwner().getName()), (Throwable)cause);
        }
        Assert.isTrue((ordinal >= 0 ? 1 : 0) != 0, (String)String.format("Element ordinal must be greater or equal to zero for property [%s] in entity [%s]", this.getName(), this.getOwner().getName()));
        return ordinal;
    }

    @Override
    public CqlIdentifier getColumnName() {
        return null;
    }

    @Override
    @Nullable
    public Integer getOrdinal() {
        return this.ordinal;
    }

    @Override
    public boolean isClusterKeyColumn() {
        return false;
    }

    @Override
    public boolean isCompositePrimaryKey() {
        return false;
    }

    @Override
    public boolean isPartitionKeyColumn() {
        return false;
    }

    @Override
    public boolean isPrimaryKeyColumn() {
        return false;
    }

    @Override
    public void setColumnName(CqlIdentifier columnName) {
        throw new UnsupportedOperationException("Cannot set a column name on a property representing a tuple element");
    }
}

