/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.mapping;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TupleType;
import java.util.List;
import org.springframework.data.cassandra.core.mapping.TupleTypeFactory;
import org.springframework.util.Assert;

public class CodecRegistryTupleTypeFactory
implements TupleTypeFactory {
    public static final CodecRegistryTupleTypeFactory DEFAULT = new CodecRegistryTupleTypeFactory();
    private final CodecRegistry codecRegistry;
    private final ProtocolVersion protocolVersion;

    private CodecRegistryTupleTypeFactory() {
        this(ProtocolVersion.NEWEST_SUPPORTED, CodecRegistry.DEFAULT_INSTANCE);
    }

    public CodecRegistryTupleTypeFactory(ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
        Assert.notNull((Object)protocolVersion, (String)"ProtocolVersion must not be null");
        Assert.notNull((Object)codecRegistry, (String)"CodecRegistry must not be null");
        this.protocolVersion = protocolVersion;
        this.codecRegistry = codecRegistry;
    }

    @Override
    public TupleType create(DataType ... types) {
        return TupleType.of((ProtocolVersion)this.protocolVersion, (CodecRegistry)this.codecRegistry, (DataType[])types);
    }

    @Override
    public TupleType create(List<DataType> types) {
        return this.create(types.toArray(new DataType[types.size()]));
    }
}

