/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.datastax.driver.core.querybuilder.Truncate;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.NonNull;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.dao.DataAccessException;
import org.springframework.data.cassandra.SessionFactory;
import org.springframework.data.cassandra.core.CassandraBatchOperations;
import org.springframework.data.cassandra.core.CassandraBatchTemplate;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.data.cassandra.core.EntityWriteResult;
import org.springframework.data.cassandra.core.ExecutableDeleteOperation;
import org.springframework.data.cassandra.core.ExecutableDeleteOperationSupport;
import org.springframework.data.cassandra.core.ExecutableInsertOperation;
import org.springframework.data.cassandra.core.ExecutableInsertOperationSupport;
import org.springframework.data.cassandra.core.ExecutableSelectOperation;
import org.springframework.data.cassandra.core.ExecutableSelectOperationSupport;
import org.springframework.data.cassandra.core.ExecutableUpdateOperation;
import org.springframework.data.cassandra.core.ExecutableUpdateOperationSupport;
import org.springframework.data.cassandra.core.InsertOptions;
import org.springframework.data.cassandra.core.QueryUtils;
import org.springframework.data.cassandra.core.StatementFactory;
import org.springframework.data.cassandra.core.UpdateOptions;
import org.springframework.data.cassandra.core.WriteResult;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.convert.MappingCassandraConverter;
import org.springframework.data.cassandra.core.convert.QueryMapper;
import org.springframework.data.cassandra.core.convert.UpdateMapper;
import org.springframework.data.cassandra.core.cql.CassandraAccessor;
import org.springframework.data.cassandra.core.cql.CqlIdentifier;
import org.springframework.data.cassandra.core.cql.CqlOperations;
import org.springframework.data.cassandra.core.cql.CqlProvider;
import org.springframework.data.cassandra.core.cql.CqlTemplate;
import org.springframework.data.cassandra.core.cql.QueryOptions;
import org.springframework.data.cassandra.core.cql.SessionCallback;
import org.springframework.data.cassandra.core.cql.WriteOptions;
import org.springframework.data.cassandra.core.cql.session.DefaultSessionFactory;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.mapping.event.AfterConvertEvent;
import org.springframework.data.cassandra.core.mapping.event.AfterDeleteEvent;
import org.springframework.data.cassandra.core.mapping.event.AfterLoadEvent;
import org.springframework.data.cassandra.core.mapping.event.AfterSaveEvent;
import org.springframework.data.cassandra.core.mapping.event.BeforeDeleteEvent;
import org.springframework.data.cassandra.core.mapping.event.BeforeSaveEvent;
import org.springframework.data.cassandra.core.query.Query;
import org.springframework.data.cassandra.core.query.Update;
import org.springframework.data.convert.EntityWriter;
import org.springframework.data.domain.Slice;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class CassandraTemplate
implements CassandraOperations,
ApplicationEventPublisherAware {
    private final CassandraConverter converter;
    private final CqlOperations cqlOperations;
    private final MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> mappingContext;
    private final SpelAwareProxyProjectionFactory projectionFactory;
    private final StatementFactory statementFactory;
    @Nullable
    private ApplicationEventPublisher eventPublisher;

    public CassandraTemplate(Session session) {
        this(session, (CassandraConverter)CassandraTemplate.newConverter());
    }

    public CassandraTemplate(Session session, CassandraConverter converter) {
        this(new DefaultSessionFactory(session), converter);
    }

    public CassandraTemplate(SessionFactory sessionFactory, CassandraConverter converter) {
        this(new CqlTemplate(sessionFactory), converter);
    }

    public CassandraTemplate(CqlOperations cqlOperations, CassandraConverter converter) {
        Assert.notNull((Object)cqlOperations, (String)"CqlOperations must not be null");
        Assert.notNull((Object)converter, (String)"CassandraConverter must not be null");
        this.converter = converter;
        this.cqlOperations = cqlOperations;
        this.mappingContext = converter.getMappingContext();
        this.projectionFactory = new SpelAwareProxyProjectionFactory();
        this.statementFactory = new StatementFactory(new QueryMapper(converter), new UpdateMapper(converter));
    }

    @Override
    public CassandraBatchOperations batchOps() {
        return new CassandraBatchTemplate(this);
    }

    @Override
    public CassandraConverter getConverter() {
        return this.converter;
    }

    @Override
    public CqlOperations getCqlOperations() {
        return this.cqlOperations;
    }

    @Override
    public CqlIdentifier getTableName(Class<?> entityClass) {
        return this.getRequiredPersistentEntity(entityClass).getTableName();
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.eventPublisher = applicationEventPublisher;
    }

    @Override
    public <T> List<T> select(String cql, Class<T> entityClass) {
        Assert.hasText((String)cql, (String)"Statement must not be empty");
        return this.select((Statement)new SimpleStatement(cql), entityClass);
    }

    @Override
    public <T> Stream<T> stream(String cql, Class<T> entityClass) throws DataAccessException {
        Assert.hasText((String)cql, (String)"Statement must not be empty");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.stream((Statement)new SimpleStatement(cql), entityClass);
    }

    @Override
    public <T> T selectOne(String cql, Class<T> entityClass) {
        Assert.hasText((String)cql, (String)"Statement must not be empty");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.selectOne((Statement)new SimpleStatement(cql), entityClass);
    }

    @Override
    public <T> List<T> select(Statement statement, Class<T> entityClass) {
        Assert.notNull((Object)statement, (String)"Statement must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        Function mapper = this.getMapper(entityClass, entityClass, QueryUtils.getTableName(statement));
        return this.getCqlOperations().query(statement, (row, rowNum) -> mapper.apply(row));
    }

    @Override
    public <T> Slice<T> slice(Statement statement, Class<T> entityClass) {
        Assert.notNull((Object)statement, (String)"Statement must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        ResultSet resultSet = this.getCqlOperations().queryForResultSet(statement);
        Function mapper = this.getMapper(entityClass, entityClass, QueryUtils.getTableName(statement));
        return QueryUtils.readSlice(resultSet, (row, rowNum) -> mapper.apply(row), 0, this.getEffectiveFetchSize(statement));
    }

    @Override
    public <T> Stream<T> stream(Statement statement, Class<T> entityClass) throws DataAccessException {
        Assert.notNull((Object)statement, (String)"Statement must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        ResultSet resultSet = this.getCqlOperations().queryForResultSet(statement);
        return StreamSupport.stream(resultSet.spliterator(), false).map(this.getMapper(entityClass, entityClass, QueryUtils.getTableName(statement)));
    }

    @Override
    public <T> T selectOne(Statement statement, Class<T> entityClass) {
        return this.select(statement, entityClass).stream().findFirst().orElse(null);
    }

    @Override
    public <T> List<T> select(Query query2, Class<T> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.doSelect(query2, entityClass, this.getTableName(entityClass), entityClass);
    }

    <T> List<T> doSelect(Query query2, Class<?> entityClass, CqlIdentifier tableName, Class<T> returnType) {
        Function mapper = this.getMapper(entityClass, returnType, tableName);
        RegularStatement select2 = this.getStatementFactory().select(query2, this.getRequiredPersistentEntity(entityClass), tableName);
        return this.getCqlOperations().query((Statement)select2, (row, rowNum) -> mapper.apply(row));
    }

    @Override
    public <T> Slice<T> slice(Query query2, Class<T> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        RegularStatement select2 = this.getStatementFactory().select(query2, this.getRequiredPersistentEntity(entityClass));
        return this.slice((Statement)select2, entityClass);
    }

    @Override
    public <T> Stream<T> stream(Query query2, Class<T> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.doStream(query2, entityClass, this.getTableName(entityClass), entityClass);
    }

    <T> Stream<T> doStream(Query query2, Class<?> entityClass, CqlIdentifier tableName, Class<T> returnType) {
        RegularStatement statement = this.getStatementFactory().select(query2, this.getRequiredPersistentEntity(entityClass), tableName);
        ResultSet resultSet = this.getCqlOperations().queryForResultSet((Statement)statement);
        return StreamSupport.stream(resultSet.spliterator(), false).map(this.getMapper(entityClass, returnType, tableName));
    }

    @Override
    public <T> T selectOne(Query query2, Class<T> entityClass) throws DataAccessException {
        List<T> result = this.select(query2, entityClass);
        return result.isEmpty() ? null : (T)result.get(0);
    }

    @Override
    public boolean update(Query query2, Update update, Class<?> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull((Object)update, (String)"Update must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        RegularStatement updateStatement = this.getStatementFactory().update(query2, update, this.getRequiredPersistentEntity(entityClass));
        return this.getCqlOperations().execute((Statement)updateStatement);
    }

    @Nullable
    WriteResult doUpdate(Query query2, Update update, Class<?> entityClass, CqlIdentifier tableName) {
        RegularStatement updateStatement = this.getStatementFactory().update(query2, update, this.getRequiredPersistentEntity(entityClass), tableName);
        return this.getCqlOperations().execute(new StatementCallback((Statement)updateStatement));
    }

    @Override
    public boolean delete(Query query2, Class<?> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        WriteResult result = this.doDelete(query2, entityClass, this.getTableName(entityClass));
        return result != null && result.wasApplied();
    }

    @Nullable
    WriteResult doDelete(Query query2, Class<?> entityClass, CqlIdentifier tableName) {
        RegularStatement delete = this.getStatementFactory().delete(query2, this.getRequiredPersistentEntity(entityClass), tableName);
        this.maybeEmitEvent(new BeforeDeleteEvent((Statement)delete, entityClass, tableName));
        WriteResult writeResult = this.getCqlOperations().execute(new StatementCallback((Statement)delete));
        this.maybeEmitEvent(new AfterDeleteEvent((Statement)delete, entityClass, tableName));
        return writeResult;
    }

    @Override
    public long count(Class<?> entityClass) {
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        Select select2 = QueryBuilder.select().countAll().from(this.getTableName(entityClass).toCql());
        Long count = this.getCqlOperations().queryForObject((Statement)select2, Long.class);
        return count != null ? count : 0L;
    }

    @Override
    public long count(Query query2, Class<?> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.doCount(query2, entityClass, this.getTableName(entityClass));
    }

    long doCount(Query query2, Class<?> entityClass, CqlIdentifier tableName) {
        RegularStatement countStatement = this.getStatementFactory().count(query2, this.getRequiredPersistentEntity(entityClass), tableName);
        Long count = this.getCqlOperations().queryForObject((Statement)countStatement, Long.class);
        return count != null ? count : 0L;
    }

    @Override
    public boolean exists(Object id, Class<?> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        CassandraPersistentEntity<?> entity = this.getRequiredPersistentEntity(entityClass);
        Select select2 = QueryBuilder.select().from(this.getTableName(entityClass).toCql());
        this.getConverter().write(id, select2.where(), entity);
        return this.getCqlOperations().queryForResultSet((Statement)select2).iterator().hasNext();
    }

    @Override
    public boolean exists(Query query2, Class<?> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.doExists(query2, entityClass, this.getTableName(entityClass));
    }

    boolean doExists(Query query2, Class<?> entityClass, CqlIdentifier tableName) {
        RegularStatement select2 = this.getStatementFactory().select(query2.limit(1L), this.getRequiredPersistentEntity(entityClass), tableName);
        return this.getCqlOperations().queryForResultSet((Statement)select2).iterator().hasNext();
    }

    @Override
    public <T> T selectOneById(Object id, Class<T> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        CqlIdentifier tableName = this.getTableName(entityClass);
        Select select2 = QueryBuilder.select().all().from(tableName.toCql());
        this.getConverter().write(id, select2.where(), this.getRequiredPersistentEntity(entityClass));
        Function mapper = this.getMapper(entityClass, entityClass, tableName);
        List<Object> result = this.getCqlOperations().query((Statement)select2, (row, rowNum) -> mapper.apply(row));
        return (T)(result.isEmpty() ? null : result.get(0));
    }

    @Override
    public <T> T insert(T entity) {
        return this.insert(entity, InsertOptions.empty()).getEntity();
    }

    @Override
    public <T> EntityWriteResult<T> insert(T entity, InsertOptions options) {
        Assert.notNull(entity, (String)"Entity must not be null");
        Assert.notNull((Object)options, (String)"InsertOptions must not be null");
        return this.doInsert(entity, options, this.getTableName(entity));
    }

    <T> EntityWriteResult<T> doInsert(T entity, WriteOptions options, CqlIdentifier tableName) {
        CassandraPersistentEntity<?> persistentEntity = this.getRequiredPersistentEntity(entity.getClass());
        Insert insert = QueryUtils.createInsertQuery(tableName.toCql(), entity, options, this.getConverter(), persistentEntity);
        this.maybeEmitEvent(new BeforeSaveEvent<T>(entity, tableName, (Statement)insert));
        WriteResult result = this.getCqlOperations().execute(new StatementCallback((Statement)insert));
        this.maybeEmitEvent(new AfterSaveEvent<T>(entity, tableName));
        return EntityWriteResult.of(result, entity);
    }

    @Override
    public <T> T update(T entity) {
        return this.update(entity, UpdateOptions.empty()).getEntity();
    }

    @Override
    public <T> EntityWriteResult<T> update(T entity, UpdateOptions options) {
        Assert.notNull(entity, (String)"Entity must not be null");
        Assert.notNull((Object)options, (String)"UpdateOptions must not be null");
        CqlIdentifier tableName = this.getTableName(entity);
        com.datastax.driver.core.querybuilder.Update update = QueryUtils.createUpdateQuery(tableName.toCql(), entity, options, (EntityWriter<Object, Object>)this.getConverter());
        this.maybeEmitEvent(new BeforeSaveEvent<T>(entity, tableName, (Statement)update));
        WriteResult result = this.getCqlOperations().execute(new StatementCallback((Statement)update));
        this.maybeEmitEvent(new AfterSaveEvent<T>(entity, tableName));
        return EntityWriteResult.of(result, entity);
    }

    @Override
    public void delete(Object entity) {
        this.delete(entity, QueryOptions.empty());
    }

    @Override
    public WriteResult delete(Object entity, QueryOptions options) {
        Assert.notNull((Object)entity, (String)"Entity must not be null");
        Assert.notNull((Object)options, (String)"QueryOptions must not be null");
        CqlIdentifier tableName = this.getTableName(entity);
        Delete delete = QueryUtils.createDeleteQuery(tableName.toCql(), entity, options, (EntityWriter<Object, Object>)this.getConverter());
        this.maybeEmitEvent(new BeforeDeleteEvent((Statement)delete, entity.getClass(), tableName));
        WriteResult result = this.getCqlOperations().execute(new StatementCallback((Statement)delete));
        this.maybeEmitEvent(new AfterDeleteEvent((Statement)delete, entity.getClass(), tableName));
        return result;
    }

    @Override
    public boolean deleteById(Object id, Class<?> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        CassandraPersistentEntity<?> entity = this.getRequiredPersistentEntity(entityClass);
        CqlIdentifier tableName = entity.getTableName();
        Delete delete = QueryBuilder.delete().from(tableName.toCql());
        this.getConverter().write(id, delete.where(), entity);
        this.maybeEmitEvent(new BeforeDeleteEvent((Statement)delete, entityClass, tableName));
        boolean result = this.getCqlOperations().execute((Statement)delete);
        this.maybeEmitEvent(new AfterDeleteEvent((Statement)delete, entityClass, tableName));
        return result;
    }

    @Override
    public void truncate(Class<?> entityClass) {
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        CqlIdentifier tableName = this.getTableName(entityClass);
        Truncate truncate = QueryBuilder.truncate((String)tableName.toCql());
        this.maybeEmitEvent(new BeforeDeleteEvent((Statement)truncate, entityClass, tableName));
        this.getCqlOperations().execute((Statement)truncate);
        this.maybeEmitEvent(new AfterDeleteEvent((Statement)truncate, entityClass, tableName));
    }

    @Override
    public <T> ExecutableSelectOperation.ExecutableSelect<T> query(Class<T> domainType) {
        return new ExecutableSelectOperationSupport(this).query(domainType);
    }

    @Override
    public <T> ExecutableInsertOperation.ExecutableInsert<T> insert(Class<T> domainType) {
        return new ExecutableInsertOperationSupport(this).insert(domainType);
    }

    @Override
    public ExecutableUpdateOperation.ExecutableUpdate update(Class<?> domainType) {
        return new ExecutableUpdateOperationSupport(this).update(domainType);
    }

    @Override
    public ExecutableDeleteOperation.ExecutableDelete delete(Class<?> domainType) {
        return new ExecutableDeleteOperationSupport(this).delete(domainType);
    }

    protected MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    protected SpelAwareProxyProjectionFactory getProjectionFactory() {
        return this.projectionFactory;
    }

    protected StatementFactory getStatementFactory() {
        return this.statementFactory;
    }

    private CqlIdentifier getTableName(Object entity) {
        return this.getRequiredPersistentEntity(entity.getClass()).getTableName();
    }

    private CassandraPersistentEntity<?> getRequiredPersistentEntity(Class<?> entityType) {
        return (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(ClassUtils.getUserClass(entityType));
    }

    private int getConfiguredFetchSize(Session session) {
        return session.getCluster().getConfiguration().getQueryOptions().getFetchSize();
    }

    private int getEffectiveFetchSize(Statement statement) {
        CassandraAccessor accessor;
        if (statement.getFetchSize() > 0) {
            return statement.getFetchSize();
        }
        if (this.getCqlOperations() instanceof CassandraAccessor && (accessor = (CassandraAccessor)((Object)this.getCqlOperations())).getFetchSize() != -1) {
            return accessor.getFetchSize();
        }
        return this.getCqlOperations().execute(this::getConfiguredFetchSize);
    }

    private <T> Function<Row, T> getMapper(Class<?> entityType, Class<T> targetType, CqlIdentifier tableName) {
        Class<?> typeToRead = this.resolveTypeToRead(entityType, targetType);
        return row -> {
            Object result;
            this.maybeEmitEvent(new AfterLoadEvent((Row)row, targetType, tableName));
            Object source = this.getConverter().read(typeToRead, row);
            Object object = result = targetType.isInterface() ? this.getProjectionFactory().createProjection(targetType, source) : source;
            if (result != null) {
                this.maybeEmitEvent(new AfterConvertEvent<Object>((Row)row, result, tableName));
            }
            return result;
        };
    }

    private Class<?> resolveTypeToRead(Class<?> entityType, Class<?> targetType) {
        return targetType.isInterface() || targetType.isAssignableFrom(entityType) ? entityType : targetType;
    }

    private void maybeEmitEvent(ApplicationEvent event) {
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent(event);
        }
    }

    private static MappingCassandraConverter newConverter() {
        MappingCassandraConverter converter = new MappingCassandraConverter();
        converter.afterPropertiesSet();
        return converter;
    }

    static final class StatementCallback
    implements SessionCallback<WriteResult>,
    CqlProvider {
        @NonNull
        private final Statement statement;

        @Override
        public WriteResult doInSession(Session session) throws DriverException, DataAccessException {
            return WriteResult.of(session.execute(this.statement));
        }

        @Override
        public String getCql() {
            return this.statement.toString();
        }

        public StatementCallback(@NonNull Statement statement) {
            if (statement == null) {
                throw new NullPointerException("statement is marked @NonNull but is null");
            }
            this.statement = statement;
        }

        @NonNull
        public Statement getStatement() {
            return this.statement;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StatementCallback)) {
                return false;
            }
            StatementCallback other = (StatementCallback)o;
            Statement this$statement = this.getStatement();
            Statement other$statement = other.getStatement();
            return !(this$statement == null ? other$statement != null : !this$statement.equals(other$statement));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Statement $statement = this.getStatement();
            result = result * 59 + ($statement == null ? 43 : $statement.hashCode());
            return result;
        }

        public String toString() {
            return "CassandraTemplate.StatementCallback(statement=" + this.getStatement() + ")";
        }
    }
}

