/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.datastax.driver.core.querybuilder.Truncate;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.NonNull;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.dao.DataAccessException;
import org.springframework.data.cassandra.SessionFactory;
import org.springframework.data.cassandra.core.AsyncCassandraOperations;
import org.springframework.data.cassandra.core.EntityWriteResult;
import org.springframework.data.cassandra.core.InsertOptions;
import org.springframework.data.cassandra.core.QueryUtils;
import org.springframework.data.cassandra.core.StatementFactory;
import org.springframework.data.cassandra.core.UpdateOptions;
import org.springframework.data.cassandra.core.WriteResult;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.convert.MappingCassandraConverter;
import org.springframework.data.cassandra.core.convert.QueryMapper;
import org.springframework.data.cassandra.core.convert.UpdateMapper;
import org.springframework.data.cassandra.core.cql.AsyncCqlOperations;
import org.springframework.data.cassandra.core.cql.AsyncCqlTemplate;
import org.springframework.data.cassandra.core.cql.AsyncSessionCallback;
import org.springframework.data.cassandra.core.cql.CassandraAccessor;
import org.springframework.data.cassandra.core.cql.CqlExceptionTranslator;
import org.springframework.data.cassandra.core.cql.CqlIdentifier;
import org.springframework.data.cassandra.core.cql.CqlProvider;
import org.springframework.data.cassandra.core.cql.GuavaListenableFutureAdapter;
import org.springframework.data.cassandra.core.cql.QueryOptions;
import org.springframework.data.cassandra.core.cql.session.DefaultSessionFactory;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.mapping.event.AfterConvertEvent;
import org.springframework.data.cassandra.core.mapping.event.AfterDeleteEvent;
import org.springframework.data.cassandra.core.mapping.event.AfterLoadEvent;
import org.springframework.data.cassandra.core.mapping.event.AfterSaveEvent;
import org.springframework.data.cassandra.core.mapping.event.BeforeDeleteEvent;
import org.springframework.data.cassandra.core.mapping.event.BeforeSaveEvent;
import org.springframework.data.cassandra.core.query.Query;
import org.springframework.data.cassandra.core.query.Update;
import org.springframework.data.convert.EntityWriter;
import org.springframework.data.domain.Slice;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureAdapter;

public class AsyncCassandraTemplate
implements AsyncCassandraOperations,
ApplicationEventPublisherAware {
    private final AsyncCqlOperations cqlOperations;
    private final CassandraConverter converter;
    private final MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> mappingContext;
    private final CqlExceptionTranslator exceptionTranslator;
    private final SpelAwareProxyProjectionFactory projectionFactory;
    private final StatementFactory statementFactory;
    @Nullable
    private ApplicationEventPublisher eventPublisher;

    public AsyncCassandraTemplate(Session session) {
        this(session, (CassandraConverter)AsyncCassandraTemplate.newConverter());
    }

    public AsyncCassandraTemplate(Session session, CassandraConverter converter) {
        this(new DefaultSessionFactory(session), converter);
    }

    public AsyncCassandraTemplate(SessionFactory sessionFactory, CassandraConverter converter) {
        this(new AsyncCqlTemplate(sessionFactory), converter);
    }

    public AsyncCassandraTemplate(AsyncCqlTemplate asyncCqlTemplate, CassandraConverter converter) {
        Assert.notNull((Object)asyncCqlTemplate, (String)"AsyncCqlTemplate must not be null");
        Assert.notNull((Object)converter, (String)"CassandraConverter must not be null");
        this.converter = converter;
        this.mappingContext = converter.getMappingContext();
        this.cqlOperations = asyncCqlTemplate;
        this.exceptionTranslator = asyncCqlTemplate.getExceptionTranslator();
        this.projectionFactory = new SpelAwareProxyProjectionFactory();
        this.statementFactory = new StatementFactory(new QueryMapper(converter), new UpdateMapper(converter));
    }

    @Override
    public AsyncCqlOperations getAsyncCqlOperations() {
        return this.cqlOperations;
    }

    @Override
    public CassandraConverter getConverter() {
        return this.converter;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.eventPublisher = applicationEventPublisher;
    }

    @Override
    public <T> ListenableFuture<List<T>> select(String cql, Class<T> entityClass) {
        Assert.hasText((String)cql, (String)"Statement must not be empty");
        return this.select((Statement)new SimpleStatement(cql), entityClass);
    }

    @Override
    public <T> ListenableFuture<Void> select(String cql, Consumer<T> entityConsumer, Class<T> entityClass) throws DataAccessException {
        Assert.hasText((String)cql, (String)"Statement must not be empty");
        Assert.notNull(entityConsumer, (String)"Entity Consumer must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.select((Statement)new SimpleStatement(cql), entityConsumer, entityClass);
    }

    @Override
    public <T> ListenableFuture<T> selectOne(String cql, Class<T> entityClass) {
        Assert.hasText((String)cql, (String)"Statement must not be empty");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.selectOne((Statement)new SimpleStatement(cql), entityClass);
    }

    @Override
    public <T> ListenableFuture<List<T>> select(Statement statement, Class<T> entityClass) {
        Assert.notNull((Object)statement, (String)"Statement must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        Function mapper = this.getMapper(entityClass, entityClass, QueryUtils.getTableName(statement));
        return this.getAsyncCqlOperations().query(statement, (row, rowNum) -> mapper.apply(row));
    }

    @Override
    public <T> ListenableFuture<Slice<T>> slice(Statement statement, Class<T> entityClass) {
        Assert.notNull((Object)statement, (String)"Statement must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        ListenableFuture<ResultSet> resultSet = this.getAsyncCqlOperations().queryForResultSet(statement);
        Function mapper = this.getMapper(entityClass, entityClass, QueryUtils.getTableName(statement));
        return new MappingListenableFutureAdapter<Slice, ResultSet>(resultSet, rs -> QueryUtils.readSlice(rs, (row, rowNum) -> mapper.apply(row), 0, this.getEffectiveFetchSize(statement)));
    }

    @Override
    public <T> ListenableFuture<Void> select(Statement statement, Consumer<T> entityConsumer, Class<T> entityClass) throws DataAccessException {
        Assert.notNull((Object)statement, (String)"Statement must not be null");
        Assert.notNull(entityConsumer, (String)"Entity Consumer must not be empty");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        Function mapper = this.getMapper(entityClass, entityClass, QueryUtils.getTableName(statement));
        return this.getAsyncCqlOperations().query(statement, row -> entityConsumer.accept(mapper.apply(row)));
    }

    @Override
    public <T> ListenableFuture<T> selectOne(Statement statement, Class<T> entityClass) {
        return new MappingListenableFutureAdapter<Object, List>(this.select(statement, entityClass), list -> list.stream().findFirst().orElse(null));
    }

    @Override
    public <T> ListenableFuture<List<T>> select(Query query2, Class<T> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.select((Statement)this.getStatementFactory().select(query2, this.getRequiredPersistentEntity(entityClass)), entityClass);
    }

    @Override
    public <T> ListenableFuture<Slice<T>> slice(Query query2, Class<T> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.slice((Statement)this.statementFactory.select(query2, this.getRequiredPersistentEntity(entityClass)), entityClass);
    }

    @Override
    public <T> ListenableFuture<Void> select(Query query2, Consumer<T> entityConsumer, Class<T> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityConsumer, (String)"Entity Consumer must not be empty");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.select((Statement)this.getStatementFactory().select(query2, this.getRequiredPersistentEntity(entityClass)), entityConsumer, entityClass);
    }

    @Override
    public <T> ListenableFuture<T> selectOne(Query query2, Class<T> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.selectOne((Statement)this.getStatementFactory().select(query2, this.getRequiredPersistentEntity(entityClass)), entityClass);
    }

    @Override
    public ListenableFuture<Boolean> update(Query query2, Update update, Class<?> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull((Object)update, (String)"Update must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.getAsyncCqlOperations().execute((Statement)this.getStatementFactory().update(query2, update, this.getRequiredPersistentEntity(entityClass)));
    }

    @Override
    public ListenableFuture<Boolean> delete(Query query2, Class<?> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.doDelete(query2, entityClass, this.getTableName(entityClass));
    }

    private ListenableFuture<Boolean> doDelete(Query query2, Class<?> entityClass, CqlIdentifier tableName) {
        RegularStatement delete = this.getStatementFactory().delete(query2, this.getRequiredPersistentEntity(entityClass), tableName);
        this.maybeEmitEvent(new BeforeDeleteEvent((Statement)delete, entityClass, tableName));
        ListenableFuture<Boolean> future = this.getAsyncCqlOperations().execute((Statement)this.getStatementFactory().delete(query2, this.getRequiredPersistentEntity(entityClass)));
        future.addCallback(success -> this.maybeEmitEvent(new AfterDeleteEvent((Statement)delete, entityClass, tableName)), e -> {});
        return future;
    }

    @Override
    public ListenableFuture<Long> count(Class<?> entityClass) {
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        Select select2 = QueryBuilder.select().countAll().from(this.getTableName(entityClass).toCql());
        return this.getAsyncCqlOperations().queryForObject((Statement)select2, Long.class);
    }

    @Override
    public ListenableFuture<Long> count(Query query2, Class<?> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        RegularStatement count = this.getStatementFactory().count(query2, this.getRequiredPersistentEntity(entityClass));
        ListenableFuture<Long> result = this.getAsyncCqlOperations().queryForObject((Statement)count, Long.class);
        return new MappingListenableFutureAdapter<Long, Long>(result, it -> it != null ? it : 0L);
    }

    @Override
    public ListenableFuture<Boolean> exists(Object id, Class<?> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        CassandraPersistentEntity<?> entity = this.getRequiredPersistentEntity(entityClass);
        Select select2 = QueryBuilder.select().from(entity.getTableName().toCql());
        this.getConverter().write(id, select2.where(), entity);
        return new MappingListenableFutureAdapter<Boolean, ResultSet>(this.getAsyncCqlOperations().queryForResultSet((Statement)select2), resultSet -> resultSet.iterator().hasNext());
    }

    @Override
    public ListenableFuture<Boolean> exists(Query query2, Class<?> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        RegularStatement select2 = this.getStatementFactory().select(query2.limit(1L), this.getRequiredPersistentEntity(entityClass));
        return new MappingListenableFutureAdapter<Boolean, ResultSet>(this.getAsyncCqlOperations().queryForResultSet((Statement)select2), resultSet -> resultSet.iterator().hasNext());
    }

    @Override
    public <T> ListenableFuture<T> selectOneById(Object id, Class<T> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        CassandraPersistentEntity<?> entity = this.getRequiredPersistentEntity(entityClass);
        Select select2 = QueryBuilder.select().all().from(entity.getTableName().toCql());
        this.getConverter().write(id, select2.where(), entity);
        Function mapper = this.getMapper(entityClass, entityClass, entity.getTableName());
        return new MappingListenableFutureAdapter<Object, List>(this.getAsyncCqlOperations().query((Statement)select2, (row, rowNum) -> mapper.apply(row)), it -> it.isEmpty() ? null : it.get(0));
    }

    @Override
    public <T> ListenableFuture<T> insert(T entity) {
        return new MappingListenableFutureAdapter<Object, EntityWriteResult>(this.insert(entity, InsertOptions.empty()), writeResult -> entity);
    }

    @Override
    public <T> ListenableFuture<EntityWriteResult<T>> insert(T entity, InsertOptions options) {
        Assert.notNull(entity, (String)"Entity must not be null");
        Assert.notNull((Object)options, (String)"InsertOptions must not be null");
        CassandraPersistentEntity<?> persistentEntity = this.getRequiredPersistentEntity(entity.getClass());
        CqlIdentifier tableName = persistentEntity.getTableName();
        Insert insert = QueryUtils.createInsertQuery(tableName.toCql(), entity, options, this.getConverter(), persistentEntity);
        this.maybeEmitEvent(new BeforeSaveEvent<T>(entity, tableName, (Statement)insert));
        return new MappingListenableFutureAdapter<EntityWriteResult, ResultSet>(this.getAsyncCqlOperations().execute(new AsyncStatementCallback((Statement)insert)), resultSet -> {
            this.maybeEmitEvent(new AfterSaveEvent<Object>(entity, tableName));
            return EntityWriteResult.of(resultSet, entity);
        });
    }

    @Override
    public <T> ListenableFuture<T> update(T entity) {
        return new MappingListenableFutureAdapter<Object, EntityWriteResult>(this.update(entity, UpdateOptions.empty()), EntityWriteResult::getEntity);
    }

    @Override
    public <T> ListenableFuture<EntityWriteResult<T>> update(T entity, UpdateOptions options) {
        Assert.notNull(entity, (String)"Entity must not be null");
        Assert.notNull((Object)options, (String)"UpdateOptions must not be null");
        CqlIdentifier tableName = this.getTableName(entity);
        com.datastax.driver.core.querybuilder.Update update = QueryUtils.createUpdateQuery(tableName.toCql(), entity, options, (EntityWriter<Object, Object>)this.getConverter());
        this.maybeEmitEvent(new BeforeSaveEvent<T>(entity, tableName, (Statement)update));
        return new MappingListenableFutureAdapter<EntityWriteResult, ResultSet>(this.getAsyncCqlOperations().execute(new AsyncStatementCallback((Statement)update)), resultSet -> {
            this.maybeEmitEvent(new AfterSaveEvent<Object>(entity, tableName));
            return EntityWriteResult.of(resultSet, entity);
        });
    }

    @Override
    public <T> ListenableFuture<T> delete(T entity) {
        return new MappingListenableFutureAdapter<Object, WriteResult>(this.delete(entity, QueryOptions.empty()), writeResult -> entity);
    }

    @Override
    public ListenableFuture<WriteResult> delete(Object entity, QueryOptions options) {
        Assert.notNull((Object)entity, (String)"Entity must not be null");
        Assert.notNull((Object)options, (String)"QueryOptions must not be null");
        CqlIdentifier tableName = this.getTableName(entity);
        Delete delete = QueryUtils.createDeleteQuery(tableName.toCql(), entity, options, (EntityWriter<Object, Object>)this.getConverter());
        this.maybeEmitEvent(new BeforeDeleteEvent((Statement)delete, entity.getClass(), tableName));
        return new MappingListenableFutureAdapter<WriteResult, ResultSet>(this.getAsyncCqlOperations().execute(new AsyncStatementCallback((Statement)delete)), resultSet -> {
            this.maybeEmitEvent(new AfterDeleteEvent((Statement)delete, entity.getClass(), tableName));
            return WriteResult.of(resultSet);
        });
    }

    @Override
    public ListenableFuture<Boolean> deleteById(Object id, Class<?> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        CassandraPersistentEntity<?> entity = this.getRequiredPersistentEntity(entityClass);
        CqlIdentifier tableName = entity.getTableName();
        Delete delete = QueryBuilder.delete().from(tableName.toCql());
        this.getConverter().write(id, delete.where(), entity);
        this.maybeEmitEvent(new BeforeDeleteEvent((Statement)delete, entityClass, tableName));
        ListenableFuture<Boolean> future = this.getAsyncCqlOperations().execute((Statement)delete);
        future.addCallback(success -> this.maybeEmitEvent(new AfterDeleteEvent((Statement)delete, entityClass, tableName)), e -> {});
        return future;
    }

    @Override
    public ListenableFuture<Void> truncate(Class<?> entityClass) {
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        CqlIdentifier tableName = this.getTableName(entityClass);
        Truncate truncate = QueryBuilder.truncate((String)tableName.toCql());
        this.maybeEmitEvent(new BeforeDeleteEvent((Statement)truncate, entityClass, tableName));
        ListenableFuture<Boolean> future = this.getAsyncCqlOperations().execute((Statement)truncate);
        future.addCallback(success -> this.maybeEmitEvent(new AfterDeleteEvent((Statement)truncate, entityClass, tableName)), e -> {});
        return new MappingListenableFutureAdapter<Void, Boolean>(future, aBoolean -> null);
    }

    protected MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    protected SpelAwareProxyProjectionFactory getProjectionFactory() {
        return this.projectionFactory;
    }

    protected StatementFactory getStatementFactory() {
        return this.statementFactory;
    }

    private CqlIdentifier getTableName(Class<?> entityClass) {
        return this.getRequiredPersistentEntity(entityClass).getTableName();
    }

    private CqlIdentifier getTableName(Object entity) {
        return this.getRequiredPersistentEntity(entity.getClass()).getTableName();
    }

    private CassandraPersistentEntity<?> getRequiredPersistentEntity(Class<?> entityType) {
        return (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(ClassUtils.getUserClass(entityType));
    }

    private int getConfiguredFetchSize(Session session) {
        return session.getCluster().getConfiguration().getQueryOptions().getFetchSize();
    }

    private int getEffectiveFetchSize(Statement statement) {
        CassandraAccessor accessor;
        if (statement.getFetchSize() > 0) {
            return statement.getFetchSize();
        }
        if (this.getAsyncCqlOperations() instanceof CassandraAccessor && (accessor = (CassandraAccessor)((Object)this.getAsyncCqlOperations())).getFetchSize() != -1) {
            return accessor.getFetchSize();
        }
        return (Integer)this.getAsyncCqlOperations().execute(session -> AsyncResult.forValue((Object)this.getConfiguredFetchSize(session))).completable().join();
    }

    private <T> Function<Row, T> getMapper(Class<?> entityType, Class<T> targetType, CqlIdentifier tableName) {
        Class<?> typeToRead = this.resolveTypeToRead(entityType, targetType);
        return row -> {
            Object result;
            this.maybeEmitEvent(new AfterLoadEvent((Row)row, targetType, tableName));
            Object source = this.getConverter().read(typeToRead, row);
            Object object = result = targetType.isInterface() ? this.getProjectionFactory().createProjection(targetType, source) : source;
            if (result != null) {
                this.maybeEmitEvent(new AfterConvertEvent<Object>((Row)row, result, tableName));
            }
            return result;
        };
    }

    private Class<?> resolveTypeToRead(Class<?> entityType, Class<?> targetType) {
        return targetType.isInterface() || targetType.isAssignableFrom(entityType) ? entityType : targetType;
    }

    private void maybeEmitEvent(ApplicationEvent event) {
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent(event);
        }
    }

    private static MappingCassandraConverter newConverter() {
        MappingCassandraConverter converter = new MappingCassandraConverter();
        converter.afterPropertiesSet();
        return converter;
    }

    final class AsyncStatementCallback
    implements AsyncSessionCallback<ResultSet>,
    CqlProvider {
        @NonNull
        private final Statement statement;

        AsyncStatementCallback(Statement statement) {
            this.statement = statement;
        }

        @Override
        public ListenableFuture<ResultSet> doInSession(Session session) throws DriverException, DataAccessException {
            return new GuavaListenableFutureAdapter<ResultSet>((com.google.common.util.concurrent.ListenableFuture<ResultSet>)session.executeAsync(this.statement), e -> e instanceof DriverException ? AsyncCassandraTemplate.this.exceptionTranslator.translate("AsyncStatementCallback", this.getCql(), (DriverException)((Object)((Object)e))) : AsyncCassandraTemplate.this.exceptionTranslator.translateExceptionIfPossible(e));
        }

        @Override
        public String getCql() {
            return this.statement.toString();
        }

        @NonNull
        public Statement getStatement() {
            return this.statement;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AsyncStatementCallback)) {
                return false;
            }
            AsyncStatementCallback other = (AsyncStatementCallback)o;
            Statement this$statement = this.getStatement();
            Statement other$statement = other.getStatement();
            return !(this$statement == null ? other$statement != null : !this$statement.equals(other$statement));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Statement $statement = this.getStatement();
            result = result * 59 + ($statement == null ? 43 : $statement.hashCode());
            return result;
        }

        public String toString() {
            return "AsyncCassandraTemplate.AsyncStatementCallback(statement=" + this.getStatement() + ")";
        }
    }

    static class MappingListenableFutureAdapter<T, S>
    extends ListenableFutureAdapter<T, S> {
        private final Function<S, T> mapper;

        MappingListenableFutureAdapter(ListenableFuture<S> adaptee, Function<S, T> mapper) {
            super(adaptee);
            this.mapper = mapper;
        }

        protected T adapt(@Nullable S adapteeResult) throws ExecutionException {
            return this.mapper.apply(adapteeResult);
        }
    }
}

