/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TableMetadata;
import java.util.Map;
import java.util.Optional;
import org.springframework.data.cassandra.SessionFactory;
import org.springframework.data.cassandra.core.CassandraAdminOperations;
import org.springframework.data.cassandra.core.CassandraTemplate;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.cql.CqlIdentifier;
import org.springframework.data.cassandra.core.cql.generator.CreateTableCqlGenerator;
import org.springframework.data.cassandra.core.cql.generator.DropTableCqlGenerator;
import org.springframework.data.cassandra.core.cql.generator.DropUserTypeCqlGenerator;
import org.springframework.data.cassandra.core.cql.keyspace.CreateTableSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.DropTableSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.DropUserTypeSpecification;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.util.Assert;

public class CassandraAdminTemplate
extends CassandraTemplate
implements CassandraAdminOperations {
    protected static final boolean DEFAULT_DROP_TABLE_IF_EXISTS = false;

    public CassandraAdminTemplate(Session session, CassandraConverter converter) {
        super(session, converter);
    }

    public CassandraAdminTemplate(SessionFactory sessionFactory, CassandraConverter converter) {
        super(sessionFactory, converter);
    }

    @Override
    public void createTable(boolean ifNotExists, CqlIdentifier tableName, Class<?> entityClass, Map<String, Object> optionsByName) {
        CassandraPersistentEntity entity = (CassandraPersistentEntity)this.getConverter().getMappingContext().getRequiredPersistentEntity(entityClass);
        CreateTableSpecification createTableSpecification = this.getConverter().getMappingContext().getCreateTableSpecificationFor(tableName, entity).ifNotExists(ifNotExists);
        this.getCqlOperations().execute(CreateTableCqlGenerator.toCql(createTableSpecification));
    }

    @Override
    public void dropTable(Class<?> entityClass) {
        this.dropTable(this.getTableName(entityClass));
    }

    @Override
    public void dropTable(CqlIdentifier tableName) {
        this.dropTable(false, tableName);
    }

    @Override
    public void dropTable(boolean ifExists, CqlIdentifier tableName) {
        String dropTableCql = DropTableCqlGenerator.toCql(DropTableSpecification.dropTable(tableName).ifExists(ifExists));
        this.getCqlOperations().execute(dropTableCql);
    }

    @Override
    public void dropUserType(CqlIdentifier typeName) {
        Assert.notNull((Object)typeName, (String)"Type name must not be null");
        String dropUserTypeCql = DropUserTypeCqlGenerator.toCql(DropUserTypeSpecification.dropType(typeName));
        this.getCqlOperations().execute(dropUserTypeCql);
    }

    @Override
    public Optional<TableMetadata> getTableMetadata(String keyspace, CqlIdentifier tableName) {
        Assert.hasText((String)keyspace, (String)"Keyspace name must not be empty");
        Assert.notNull((Object)tableName, (String)"Table name must not be null");
        return Optional.ofNullable(this.getCqlOperations().execute(session -> session.getCluster().getMetadata().getKeyspace(Metadata.quoteIfNecessary((String)keyspace)).getTable(tableName.toCql())));
    }

    @Override
    public KeyspaceMetadata getKeyspaceMetadata() {
        return this.getCqlOperations().execute(session -> {
            String keyspace = Metadata.quoteIfNecessary((String)session.getLoggedKeyspace());
            KeyspaceMetadata keyspaceMetadata = session.getCluster().getMetadata().getKeyspace(keyspace);
            Assert.state((keyspaceMetadata != null ? 1 : 0) != 0, (String)String.format("Metadata for keyspace [%s] not available", keyspace));
            return keyspaceMetadata;
        });
    }
}

