/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import java.util.Iterator;
import java.util.List;
import lombok.NonNull;
import org.springframework.core.convert.converter.Converter;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.query.CassandraPageRequest;
import org.springframework.data.cassandra.repository.query.DtoInstantiatingConverter;
import org.springframework.data.cassandra.repository.query.ProjectionUtil;
import org.springframework.data.convert.EntityInstantiators;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

@FunctionalInterface
interface CassandraQueryExecution {
    @Nullable
    public Object execute(Statement var1, Class<?> var2);

    public static final class ResultProcessingConverter
    implements Converter<Object, Object> {
        @NonNull
        private final ResultProcessor processor;
        @NonNull
        private final MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> mappingContext;
        @NonNull
        private final EntityInstantiators instantiators;

        public Object convert(@Nullable Object source) {
            ReturnedType returnedType = this.processor.getReturnedType();
            if (ClassUtils.isPrimitiveOrWrapper((Class)returnedType.getReturnedType())) {
                return source;
            }
            if (source != null && returnedType.isInstance(source)) {
                return source;
            }
            DtoInstantiatingConverter converter = new DtoInstantiatingConverter(returnedType.getReturnedType(), this.mappingContext, this.instantiators);
            return this.processor.processResult(source, (Converter)converter);
        }

        public ResultProcessingConverter(@NonNull ResultProcessor processor, @NonNull MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> mappingContext, @NonNull EntityInstantiators instantiators) {
            if (processor == null) {
                throw new NullPointerException("processor is marked @NonNull but is null");
            }
            if (mappingContext == null) {
                throw new NullPointerException("mappingContext is marked @NonNull but is null");
            }
            if (instantiators == null) {
                throw new NullPointerException("instantiators is marked @NonNull but is null");
            }
            this.processor = processor;
            this.mappingContext = mappingContext;
            this.instantiators = instantiators;
        }
    }

    public static final class ResultProcessingExecution
    implements CassandraQueryExecution {
        @NonNull
        private final CassandraQueryExecution delegate;
        @NonNull
        private final Converter<Object, Object> converter;

        @Override
        @Nullable
        public Object execute(Statement statement, Class<?> type) {
            Object result = this.delegate.execute(statement, type);
            return result != null ? this.converter.convert(result) : null;
        }

        public ResultProcessingExecution(@NonNull CassandraQueryExecution delegate, @NonNull Converter<Object, Object> converter) {
            if (delegate == null) {
                throw new NullPointerException("delegate is marked @NonNull but is null");
            }
            if (converter == null) {
                throw new NullPointerException("converter is marked @NonNull but is null");
            }
            this.delegate = delegate;
            this.converter = converter;
        }
    }

    public static final class ResultSetQuery
    implements CassandraQueryExecution {
        @NonNull
        private final CassandraOperations operations;

        @Override
        public Object execute(Statement statement, Class<?> type) {
            return this.operations.getCqlOperations().queryForResultSet(statement);
        }

        public ResultSetQuery(@NonNull CassandraOperations operations) {
            if (operations == null) {
                throw new NullPointerException("operations is marked @NonNull but is null");
            }
            this.operations = operations;
        }
    }

    public static final class ExistsExecution
    implements CassandraQueryExecution {
        @NonNull
        private final CassandraOperations operations;

        @Override
        public Object execute(Statement statement, Class<?> type) {
            ResultSet resultSet = this.operations.getCqlOperations().queryForResultSet(statement);
            Iterator iterator = resultSet.iterator();
            if (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                if (!iterator.hasNext() && ProjectionUtil.qualifiesAsCountProjection(row)) {
                    Object object = row.getObject(0);
                    return ((Number)object).longValue() > 0L;
                }
                return true;
            }
            return false;
        }

        public ExistsExecution(@NonNull CassandraOperations operations) {
            if (operations == null) {
                throw new NullPointerException("operations is marked @NonNull but is null");
            }
            this.operations = operations;
        }
    }

    public static final class SingleEntityExecution
    implements CassandraQueryExecution {
        @NonNull
        private final CassandraOperations operations;
        private final boolean limiting;

        @Override
        public Object execute(Statement statement, Class<?> type) {
            List<?> objects = this.operations.select(statement, type);
            if (objects.isEmpty()) {
                return null;
            }
            if (objects.size() == 1 || this.limiting) {
                return objects.get(0);
            }
            throw new IncorrectResultSizeDataAccessException(1, objects.size());
        }

        public SingleEntityExecution(@NonNull CassandraOperations operations, boolean limiting) {
            if (operations == null) {
                throw new NullPointerException("operations is marked @NonNull but is null");
            }
            this.operations = operations;
            this.limiting = limiting;
        }
    }

    public static final class CollectionExecution
    implements CassandraQueryExecution {
        @NonNull
        private final CassandraOperations operations;

        @Override
        public Object execute(Statement statement, Class<?> type) {
            return this.operations.select(statement, type);
        }

        public CollectionExecution(@NonNull CassandraOperations operations) {
            if (operations == null) {
                throw new NullPointerException("operations is marked @NonNull but is null");
            }
            this.operations = operations;
        }
    }

    public static final class SlicedExecution
    implements CassandraQueryExecution {
        @NonNull
        private final CassandraOperations operations;
        @NonNull
        private final Pageable pageable;

        @Override
        public Object execute(Statement statement, Class<?> type) {
            CassandraPageRequest.validatePageable(this.pageable);
            Statement statementToUse = statement.setFetchSize(this.pageable.getPageSize());
            if (this.pageable instanceof CassandraPageRequest) {
                statementToUse = statementToUse.setPagingState(((CassandraPageRequest)this.pageable).getPagingState());
            }
            Slice<?> slice = this.operations.slice(statementToUse, type);
            if (this.pageable.getSort().isUnsorted()) {
                return slice;
            }
            CassandraPageRequest cassandraPageRequest = (CassandraPageRequest)slice.getPageable();
            return new SliceImpl(slice.getContent(), (Pageable)cassandraPageRequest.withSort(this.pageable.getSort()), slice.hasNext());
        }

        public SlicedExecution(@NonNull CassandraOperations operations, @NonNull Pageable pageable) {
            if (operations == null) {
                throw new NullPointerException("operations is marked @NonNull but is null");
            }
            if (pageable == null) {
                throw new NullPointerException("pageable is marked @NonNull but is null");
            }
            this.operations = operations;
            this.pageable = pageable;
        }
    }

    public static final class StreamExecution
    implements CassandraQueryExecution {
        @NonNull
        private final CassandraOperations operations;
        @NonNull
        private final Converter<Object, Object> resultProcessing;

        @Override
        public Object execute(Statement statement, Class<?> type) {
            return this.operations.stream(statement, type).map(arg_0 -> this.resultProcessing.convert(arg_0));
        }

        public StreamExecution(@NonNull CassandraOperations operations, @NonNull Converter<Object, Object> resultProcessing) {
            if (operations == null) {
                throw new NullPointerException("operations is marked @NonNull but is null");
            }
            if (resultProcessing == null) {
                throw new NullPointerException("resultProcessing is marked @NonNull but is null");
            }
            this.operations = operations;
            this.resultProcessing = resultProcessing;
        }
    }
}

