/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.mapping;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.mapping.MappingException;
import org.springframework.util.Assert;

public class VerifierMappingExceptions
extends MappingException {
    private final Collection<MappingException> exceptions;
    private final String className;

    public VerifierMappingExceptions(CassandraPersistentEntity<?> entity, Collection<MappingException> exceptions) {
        super(String.format("Mapping Exceptions for %s", entity.getName()));
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        this.exceptions = Collections.unmodifiableCollection(new LinkedList<MappingException>(exceptions));
        this.className = entity.getType().getName();
        this.exceptions.forEach(arg_0 -> this.addSuppressed(arg_0));
    }

    public VerifierMappingExceptions(CassandraPersistentEntity<?> entity, String message) {
        super(message);
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        this.exceptions = Collections.emptyList();
        this.className = entity.getType().getName();
    }

    public Collection<MappingException> getMappingExceptions() {
        return this.exceptions;
    }

    public Collection<String> getMessages() {
        return this.exceptions.stream().map(Throwable::getMessage).collect(Collectors.toList());
    }

    public String getMessage() {
        StringBuilder builder = new StringBuilder(this.className).append(":\n");
        this.exceptions.forEach(e -> builder.append(" - ").append(e.getMessage()).append("\n"));
        return builder.toString();
    }
}

