/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.convert;

import com.datastax.driver.core.DataType;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.cassandra.core.convert.CassandraConverters;
import org.springframework.data.cassandra.core.convert.CassandraJodaTimeConverters;
import org.springframework.data.cassandra.core.convert.CassandraJsr310Converters;
import org.springframework.data.cassandra.core.convert.CassandraThreeTenBackPortConverters;
import org.springframework.data.cassandra.core.mapping.CassandraSimpleTypeHolder;
import org.springframework.data.cassandra.core.mapping.CassandraType;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.convert.WritingConverter;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class CassandraCustomConversions
extends CustomConversions {
    private static final List<Object> STORE_CONVERTERS;
    private static final Set<Class<?>> NATIVE_TIME_TYPE_MARKERS;
    private static final CustomConversions.StoreConversions STORE_CONVERSIONS;

    public CassandraCustomConversions(List<?> converters) {
        super(STORE_CONVERSIONS, converters);
    }

    public boolean isNativeTimeTypeMarker(Class<?> type) {
        Assert.notNull(type, (String)"Type must not be null");
        return NATIVE_TIME_TYPE_MARKERS.contains(ClassUtils.getUserClass(type));
    }

    static {
        ArrayList<Object> converters = new ArrayList<Object>();
        converters.addAll(CassandraConverters.getConvertersToRegister());
        converters.addAll(CassandraJodaTimeConverters.getConvertersToRegister());
        converters.addAll(CassandraJsr310Converters.getConvertersToRegister());
        converters.addAll(CassandraThreeTenBackPortConverters.getConvertersToRegister());
        STORE_CONVERTERS = Collections.unmodifiableList(converters);
        STORE_CONVERSIONS = CustomConversions.StoreConversions.of((SimpleTypeHolder)CassandraSimpleTypeHolder.HOLDER, STORE_CONVERTERS);
        List timeMarkers = STORE_CONVERTERS.stream().filter(Converter.class::isInstance).map(Object::getClass).filter(it -> AnnotatedElementUtils.hasAnnotation((AnnotatedElement)it, WritingConverter.class)).filter(it -> {
            CassandraType annotation = (CassandraType)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)it, CassandraType.class);
            return annotation != null && annotation.type() == DataType.Name.TIME;
        }).map(it -> {
            ResolvableType classType = ResolvableType.forClass((Class)it).as(Converter.class).getGeneric(new int[]{0});
            return classType.getRawClass();
        }).collect(Collectors.toList());
        NATIVE_TIME_TYPE_MARKERS = new HashSet(timeMarkers);
    }
}

