/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.policies.RetryPolicy;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.springframework.data.cassandra.core.cql.WriteOptions;
import org.springframework.lang.Nullable;

public class UpdateOptions
extends WriteOptions {
    private static final UpdateOptions EMPTY = new UpdateOptionsBuilder().build();
    private boolean ifExists;

    private UpdateOptions(@Nullable ConsistencyLevel consistencyLevel, @Nullable RetryPolicy retryPolicy, @Nullable Boolean tracing, @Nullable Integer fetchSize, Duration readTimeout, Duration ttl, boolean ifExists) {
        super(consistencyLevel, retryPolicy, tracing, fetchSize, readTimeout, ttl);
        this.ifExists = ifExists;
    }

    public static UpdateOptionsBuilder builder() {
        return new UpdateOptionsBuilder();
    }

    public static UpdateOptions empty() {
        return EMPTY;
    }

    @Override
    public UpdateOptionsBuilder mutate() {
        return new UpdateOptionsBuilder(this);
    }

    public boolean isIfExists() {
        return this.ifExists;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateOptions)) {
            return false;
        }
        UpdateOptions other = (UpdateOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.isIfExists() == other.isIfExists();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof UpdateOptions;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isIfExists() ? 79 : 97);
        return result;
    }

    public static class UpdateOptionsBuilder
    extends WriteOptions.WriteOptionsBuilder {
        private boolean ifExists;

        private UpdateOptionsBuilder() {
        }

        private UpdateOptionsBuilder(UpdateOptions updateOptions) {
            super(updateOptions);
            this.ifExists = updateOptions.ifExists;
        }

        @Override
        public UpdateOptionsBuilder consistencyLevel(ConsistencyLevel consistencyLevel) {
            return (UpdateOptionsBuilder)super.consistencyLevel(consistencyLevel);
        }

        @Override
        public UpdateOptionsBuilder retryPolicy(RetryPolicy driverRetryPolicy) {
            return (UpdateOptionsBuilder)super.retryPolicy(driverRetryPolicy);
        }

        @Override
        public UpdateOptionsBuilder fetchSize(int fetchSize) {
            return (UpdateOptionsBuilder)super.fetchSize(fetchSize);
        }

        @Override
        public UpdateOptionsBuilder readTimeout(long readTimeout) {
            return (UpdateOptionsBuilder)super.readTimeout(readTimeout);
        }

        @Override
        @Deprecated
        public UpdateOptionsBuilder readTimeout(long readTimeout, TimeUnit timeUnit) {
            return (UpdateOptionsBuilder)super.readTimeout(readTimeout, timeUnit);
        }

        @Override
        public UpdateOptionsBuilder readTimeout(Duration readTimeout) {
            return (UpdateOptionsBuilder)super.readTimeout(readTimeout);
        }

        @Override
        public UpdateOptionsBuilder ttl(Duration ttl) {
            return (UpdateOptionsBuilder)super.ttl(ttl);
        }

        @Override
        public UpdateOptionsBuilder tracing(boolean tracing) {
            return (UpdateOptionsBuilder)super.tracing(tracing);
        }

        @Override
        public UpdateOptionsBuilder withTracing() {
            return (UpdateOptionsBuilder)super.withTracing();
        }

        @Override
        public UpdateOptionsBuilder ttl(int ttl) {
            return (UpdateOptionsBuilder)super.ttl(ttl);
        }

        public UpdateOptionsBuilder withIfExists() {
            return this.ifExists(true);
        }

        public UpdateOptionsBuilder ifExists(boolean ifNotExists) {
            this.ifExists = ifNotExists;
            return this;
        }

        @Override
        public UpdateOptions build() {
            return new UpdateOptions(this.consistencyLevel, this.retryPolicy, this.tracing, this.fetchSize, this.readTimeout, this.ttl, this.ifExists);
        }
    }
}

