/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.mapping;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.UserType;
import org.springframework.data.cassandra.core.cql.CqlIdentifier;
import org.springframework.data.cassandra.core.mapping.UserTypeResolver;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SimpleUserTypeResolver
implements UserTypeResolver {
    private final String keyspaceName;
    private final Cluster cluster;

    public SimpleUserTypeResolver(Cluster cluster, String keyspaceName) {
        Assert.notNull((Object)cluster, (String)"Cluster must not be null");
        Assert.hasText((String)keyspaceName, (String)"Keyspace must not be null or empty");
        this.keyspaceName = keyspaceName;
        this.cluster = cluster;
    }

    @Override
    @Nullable
    public UserType resolveType(CqlIdentifier typeName) {
        KeyspaceMetadata keyspace = this.cluster.getMetadata().getKeyspace(this.keyspaceName);
        return keyspace.getUserType(typeName.toCql());
    }
}

