/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.policies.RetryPolicy;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.data.cassandra.ReactiveResultSet;
import org.springframework.data.cassandra.ReactiveSession;
import org.springframework.data.cassandra.ReactiveSessionFactory;
import org.springframework.data.cassandra.core.cql.ArgumentPreparedStatementBinder;
import org.springframework.data.cassandra.core.cql.ColumnMapRowMapper;
import org.springframework.data.cassandra.core.cql.CqlProvider;
import org.springframework.data.cassandra.core.cql.PreparedStatementBinder;
import org.springframework.data.cassandra.core.cql.ReactiveCassandraAccessor;
import org.springframework.data.cassandra.core.cql.ReactiveCqlOperations;
import org.springframework.data.cassandra.core.cql.ReactivePreparedStatementCallback;
import org.springframework.data.cassandra.core.cql.ReactivePreparedStatementCreator;
import org.springframework.data.cassandra.core.cql.ReactiveResultSetExtractor;
import org.springframework.data.cassandra.core.cql.ReactiveRowMapperResultSetExtractor;
import org.springframework.data.cassandra.core.cql.ReactiveSessionCallback;
import org.springframework.data.cassandra.core.cql.ReactiveStatementCallback;
import org.springframework.data.cassandra.core.cql.RowMapper;
import org.springframework.data.cassandra.core.cql.SingleColumnRowMapper;
import org.springframework.data.cassandra.core.cql.session.DefaultReactiveSessionFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveCqlTemplate
extends ReactiveCassandraAccessor
implements ReactiveCqlOperations {
    private static final Statement DEFAULTS = QueryBuilder.select().from("DEFAULT");
    private int fetchSize = -1;
    @Nullable
    private RetryPolicy retryPolicy;
    @Nullable
    private ConsistencyLevel consistencyLevel;

    public ReactiveCqlTemplate() {
    }

    public ReactiveCqlTemplate(ReactiveSession reactiveSession) {
        Assert.notNull((Object)reactiveSession, (String)"ReactiveSession must not be null");
        this.setSessionFactory(new DefaultReactiveSessionFactory(reactiveSession));
        this.afterPropertiesSet();
    }

    public ReactiveCqlTemplate(ReactiveSessionFactory reactiveSessionFactory) {
        this.setSessionFactory(reactiveSessionFactory);
        this.afterPropertiesSet();
    }

    public void setConsistencyLevel(@Nullable ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
    }

    @Nullable
    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setRetryPolicy(@Nullable RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    @Nullable
    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    @Override
    public <T> Flux<T> execute(ReactiveSessionCallback<T> action) throws DataAccessException {
        Assert.notNull(action, (String)"Callback object must not be null");
        return this.createFlux(action).onErrorMap(this.translateException("ReactiveSessionCallback", ReactiveCqlTemplate.getCql(action)));
    }

    @Override
    public Mono<Boolean> execute(String cql) throws DataAccessException {
        Assert.hasText((String)cql, (String)"CQL must not be empty");
        return this.queryForResultSet(cql).map(ReactiveResultSet::wasApplied);
    }

    @Override
    public <T> Flux<T> query(String cql, ReactiveResultSetExtractor<T> resultSetExtractor) throws DataAccessException {
        Assert.hasText((String)cql, (String)"CQL must not be empty");
        Assert.notNull(resultSetExtractor, (String)"ReactiveResultSetExtractor must not be null");
        return this.createFlux((Statement)new SimpleStatement(cql), (session, stmt) -> {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Executing CQL Statement [{}]", (Object)cql);
            }
            return session.execute(stmt).flatMapMany(resultSetExtractor::extractData);
        }).onErrorMap(this.translateException("Query", cql));
    }

    @Override
    public <T> Flux<T> query(String cql, RowMapper<T> rowMapper) throws DataAccessException {
        return this.query(cql, new ReactiveRowMapperResultSetExtractor<T>(rowMapper));
    }

    @Override
    public <T> Mono<T> queryForObject(String cql, RowMapper<T> rowMapper) throws DataAccessException {
        return this.query(cql, rowMapper).buffer(2).flatMap(list -> Mono.just((Object)DataAccessUtils.requiredSingleResult((Collection)list))).next();
    }

    @Override
    public <T> Mono<T> queryForObject(String cql, Class<T> requiredType) throws DataAccessException {
        return this.queryForObject(cql, this.getSingleColumnRowMapper(requiredType));
    }

    @Override
    public Mono<Map<String, Object>> queryForMap(String cql) throws DataAccessException {
        return this.queryForObject(cql, this.getColumnMapRowMapper());
    }

    @Override
    public <T> Flux<T> queryForFlux(String cql, Class<T> elementType) throws DataAccessException {
        return this.query(cql, this.getSingleColumnRowMapper(elementType));
    }

    @Override
    public Flux<Map<String, Object>> queryForFlux(String cql) throws DataAccessException {
        return this.query(cql, this.getColumnMapRowMapper());
    }

    @Override
    public Mono<ReactiveResultSet> queryForResultSet(String cql) throws DataAccessException {
        Assert.hasText((String)cql, (String)"CQL must not be empty");
        return this.createMono((Statement)new SimpleStatement(cql), (session, statement) -> {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Executing CQL [{}]", (Object)cql);
            }
            return session.execute(statement);
        }).onErrorMap(this.translateException("QueryForResultSet", cql));
    }

    @Override
    public Flux<Row> queryForRows(String cql) throws DataAccessException {
        return this.queryForResultSet(cql).flatMapMany(ReactiveResultSet::rows).onErrorMap(this.translateException("QueryForRows", cql));
    }

    @Override
    public Flux<Boolean> execute(Publisher<String> statementPublisher) throws DataAccessException {
        Assert.notNull(statementPublisher, (String)"CQL Publisher must not be null");
        return Flux.from(statementPublisher).flatMap(this::execute);
    }

    @Override
    public Mono<Boolean> execute(Statement statement) throws DataAccessException {
        Assert.notNull((Object)statement, (String)"CQL Statement must not be null");
        return this.queryForResultSet(statement).map(ReactiveResultSet::wasApplied);
    }

    @Override
    public <T> Flux<T> query(Statement statement, ReactiveResultSetExtractor<T> rse) throws DataAccessException {
        Assert.notNull((Object)statement, (String)"CQL Statement must not be null");
        Assert.notNull(rse, (String)"ReactiveResultSetExtractor must not be null");
        return this.createFlux(statement, (session, stmt) -> {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Executing CQL Statement [{}]", (Object)statement);
            }
            return session.execute(stmt).flatMapMany(rse::extractData);
        }).onErrorMap(this.translateException("Query", statement.toString()));
    }

    @Override
    public <T> Flux<T> query(Statement statement, RowMapper<T> rowMapper) throws DataAccessException {
        return this.query(statement, new ReactiveRowMapperResultSetExtractor<T>(rowMapper));
    }

    @Override
    public <T> Mono<T> queryForObject(Statement statement, RowMapper<T> rowMapper) throws DataAccessException {
        return this.query(statement, rowMapper).buffer(2).flatMap(list -> Mono.just((Object)DataAccessUtils.requiredSingleResult((Collection)list))).next();
    }

    @Override
    public <T> Mono<T> queryForObject(Statement statement, Class<T> requiredType) throws DataAccessException {
        return this.queryForObject(statement, this.getSingleColumnRowMapper(requiredType));
    }

    @Override
    public Mono<Map<String, Object>> queryForMap(Statement statement) throws DataAccessException {
        return this.queryForObject(statement, this.getColumnMapRowMapper());
    }

    @Override
    public <T> Flux<T> queryForFlux(Statement statement, Class<T> elementType) throws DataAccessException {
        return this.query(statement, this.getSingleColumnRowMapper(elementType));
    }

    @Override
    public Flux<Map<String, Object>> queryForFlux(Statement statement) throws DataAccessException {
        return this.query(statement, this.getColumnMapRowMapper());
    }

    @Override
    public Mono<ReactiveResultSet> queryForResultSet(Statement statement) throws DataAccessException {
        Assert.notNull((Object)statement, (String)"CQL Statement must not be null");
        return this.createMono(statement, (session, executedStatement) -> {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Executing CQL [{}]", (Object)executedStatement);
            }
            return session.execute(executedStatement);
        }).onErrorMap(this.translateException("QueryForResultSet", statement.toString()));
    }

    @Override
    public Flux<Row> queryForRows(Statement statement) throws DataAccessException {
        return this.queryForResultSet(statement).flatMapMany(ReactiveResultSet::rows).onErrorMap(this.translateException("QueryForRows", statement.toString()));
    }

    @Override
    public <T> Flux<T> execute(ReactivePreparedStatementCreator psc, ReactivePreparedStatementCallback<T> action) throws DataAccessException {
        Assert.notNull((Object)psc, (String)"ReactivePreparedStatementCreator must not be null");
        Assert.notNull(action, (String)"ReactivePreparedStatementCallback object must not be null");
        return this.createFlux(session -> {
            this.logger.debug("Preparing statement [{}] using {}", (Object)ReactiveCqlTemplate.getCql(psc), (Object)psc);
            return psc.createPreparedStatement(session).doOnNext(this::applyStatementSettings).flatMapMany(ps -> action.doInPreparedStatement(session, (PreparedStatement)ps));
        }).onErrorMap(this.translateException("ReactivePreparedStatementCallback", ReactiveCqlTemplate.getCql(psc)));
    }

    @Override
    public <T> Flux<T> execute(String cql, ReactivePreparedStatementCallback<T> action) throws DataAccessException {
        return this.execute(this.newReactivePreparedStatementCreator(cql), action);
    }

    @Override
    public <T> Flux<T> query(ReactivePreparedStatementCreator psc, @Nullable PreparedStatementBinder preparedStatementBinder, ReactiveResultSetExtractor<T> rse) throws DataAccessException {
        Assert.notNull((Object)psc, (String)"ReactivePreparedStatementCreator must not be null");
        Assert.notNull(rse, (String)"ReactiveResultSetExtractor object must not be null");
        return this.execute(psc, (ReactiveSession session, PreparedStatement ps) -> Mono.just((Object)ps).flatMapMany(pps -> {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Executing Prepared CQL Statement [{}]", (Object)ps.getQueryString());
            }
            BoundStatement boundStatement = preparedStatementBinder != null ? preparedStatementBinder.bindValues(ps) : ps.bind();
            this.applyStatementSettings((Statement)boundStatement);
            return session.execute((Statement)boundStatement);
        }).flatMap(rse::extractData)).onErrorMap(this.translateException("Query", ReactiveCqlTemplate.getCql(psc)));
    }

    @Override
    public <T> Flux<T> query(ReactivePreparedStatementCreator psc, ReactiveResultSetExtractor<T> rse) throws DataAccessException {
        return this.query(psc, null, rse);
    }

    @Override
    public <T> Flux<T> query(String cql, @Nullable PreparedStatementBinder psb, ReactiveResultSetExtractor<T> rse) throws DataAccessException {
        return this.query(this.newReactivePreparedStatementCreator(cql), psb, rse);
    }

    @Override
    public <T> Flux<T> query(String cql, ReactiveResultSetExtractor<T> rse, Object ... args) throws DataAccessException {
        return this.query(this.newReactivePreparedStatementCreator(cql), this.newArgPreparedStatementBinder(args), rse);
    }

    @Override
    public <T> Flux<T> query(ReactivePreparedStatementCreator psc, RowMapper<T> rowMapper) throws DataAccessException {
        return this.query(psc, null, new ReactiveRowMapperResultSetExtractor<T>(rowMapper));
    }

    @Override
    public <T> Flux<T> query(String cql, @Nullable PreparedStatementBinder psb, RowMapper<T> rowMapper) throws DataAccessException {
        return this.query(cql, psb, new ReactiveRowMapperResultSetExtractor<T>(rowMapper));
    }

    @Override
    public <T> Flux<T> query(ReactivePreparedStatementCreator psc, @Nullable PreparedStatementBinder psb, RowMapper<T> rowMapper) throws DataAccessException {
        return this.query(psc, psb, new ReactiveRowMapperResultSetExtractor<T>(rowMapper));
    }

    @Override
    public <T> Flux<T> query(String cql, RowMapper<T> rowMapper, Object ... args) throws DataAccessException {
        return this.query(cql, this.newArgPreparedStatementBinder(args), rowMapper);
    }

    @Override
    public <T> Mono<T> queryForObject(String cql, RowMapper<T> rowMapper, Object ... args) throws DataAccessException {
        return this.query(cql, rowMapper, args).buffer(2).flatMap(list -> Mono.just((Object)DataAccessUtils.requiredSingleResult((Collection)list))).next();
    }

    @Override
    public <T> Mono<T> queryForObject(String cql, Class<T> requiredType, Object ... args) throws DataAccessException {
        return this.queryForObject(cql, this.getSingleColumnRowMapper(requiredType), args);
    }

    @Override
    public Mono<Map<String, Object>> queryForMap(String cql, Object ... args) throws DataAccessException {
        return this.queryForObject(cql, this.getColumnMapRowMapper(), args);
    }

    @Override
    public <T> Flux<T> queryForFlux(String cql, Class<T> elementType, Object ... args) throws DataAccessException {
        return this.query(cql, this.getSingleColumnRowMapper(elementType), args);
    }

    @Override
    public Flux<Map<String, Object>> queryForFlux(String cql, Object ... args) throws DataAccessException {
        return this.query(cql, this.getColumnMapRowMapper(), args);
    }

    @Override
    public Mono<ReactiveResultSet> queryForResultSet(String cql, Object ... args) throws DataAccessException {
        Assert.hasText((String)cql, (String)"CQL must not be empty");
        return this.query(this.newReactivePreparedStatementCreator(cql), this.newArgPreparedStatementBinder(args), Mono::just).next();
    }

    @Override
    public Flux<Row> queryForRows(String cql, Object ... args) throws DataAccessException {
        return this.queryForResultSet(cql, args).flatMapMany(ReactiveResultSet::rows).onErrorMap(this.translateException("QueryForRows", cql));
    }

    @Override
    public Mono<Boolean> execute(ReactivePreparedStatementCreator psc) throws DataAccessException {
        return this.query(psc, (ReactiveResultSet resultSet) -> Mono.just((Object)resultSet.wasApplied())).last();
    }

    @Override
    public Mono<Boolean> execute(String cql, @Nullable PreparedStatementBinder psb) throws DataAccessException {
        return this.query(this.newReactivePreparedStatementCreator(cql), psb, (ReactiveResultSet resultSet) -> Mono.just((Object)resultSet.wasApplied())).next();
    }

    @Override
    public Mono<Boolean> execute(String cql, Object ... args) throws DataAccessException {
        return this.execute(cql, this.newArgPreparedStatementBinder(args));
    }

    @Override
    public Flux<Boolean> execute(String cql, Publisher<Object[]> args) throws DataAccessException {
        Assert.notNull(args, (String)"Args Publisher must not be null");
        return this.execute(this.newReactivePreparedStatementCreator(cql), (ReactiveSession session, PreparedStatement ps) -> Flux.from((Publisher)args).flatMap(objects -> {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Executing Prepared CQL Statement [{}]", (Object)cql);
            }
            BoundStatement boundStatement = this.newArgPreparedStatementBinder((Object[])objects).bindValues(ps);
            this.applyStatementSettings((Statement)boundStatement);
            return session.execute((Statement)boundStatement);
        }).map(ReactiveResultSet::wasApplied));
    }

    protected ReactivePreparedStatementCreator newReactivePreparedStatementCreator(String cql) {
        return new SimpleReactivePreparedStatementCreator(cql);
    }

    protected <T> Flux<T> createFlux(Statement statement, ReactiveStatementCallback<T> callback) {
        Assert.notNull(callback, (String)"ReactiveStatementCallback must not be null");
        this.applyStatementSettings(statement);
        ReactiveSession session = this.getSession();
        return Flux.defer(() -> callback.doInStatement(session, statement));
    }

    protected <T> Mono<T> createMono(Statement statement, ReactiveStatementCallback<T> callback) {
        Assert.notNull(callback, (String)"ReactiveStatementCallback must not be null");
        this.applyStatementSettings(statement);
        ReactiveSession session = this.getSession();
        return Mono.defer(() -> Mono.from(callback.doInStatement(session, statement)));
    }

    protected <T> Flux<T> createFlux(ReactiveSessionCallback<T> callback) {
        Assert.notNull(callback, (String)"ReactiveStatementCallback must not be null");
        ReactiveSession session = this.getSession();
        return Flux.defer(() -> callback.doInSession(session));
    }

    protected Function<Throwable, Throwable> translateException(String task, @Nullable String cql) {
        return throwable -> throwable instanceof DriverException ? this.translate(task, cql, (DriverException)throwable) : throwable;
    }

    protected RowMapper<Map<String, Object>> getColumnMapRowMapper() {
        return new ColumnMapRowMapper();
    }

    protected <T> RowMapper<T> getSingleColumnRowMapper(Class<T> requiredType) {
        return SingleColumnRowMapper.newInstance(requiredType);
    }

    protected void applyStatementSettings(Statement stmt) {
        RetryPolicy retryPolicy;
        int fetchSize;
        ConsistencyLevel consistencyLevel = this.getConsistencyLevel();
        if (consistencyLevel != null && stmt.getConsistencyLevel() == DEFAULTS.getConsistencyLevel()) {
            stmt.setConsistencyLevel(consistencyLevel);
        }
        if ((fetchSize = this.getFetchSize()) != -1 && stmt.getFetchSize() == DEFAULTS.getFetchSize()) {
            stmt.setFetchSize(fetchSize);
        }
        if ((retryPolicy = this.getRetryPolicy()) != null && stmt.getRetryPolicy() == DEFAULTS.getRetryPolicy()) {
            stmt.setRetryPolicy(retryPolicy);
        }
    }

    protected void applyStatementSettings(PreparedStatement stmt) {
        RetryPolicy retryPolicy;
        ConsistencyLevel consistencyLevel = this.getConsistencyLevel();
        if (consistencyLevel != null) {
            stmt.setConsistencyLevel(consistencyLevel);
        }
        if ((retryPolicy = this.getRetryPolicy()) != null) {
            stmt.setRetryPolicy(retryPolicy);
        }
    }

    protected PreparedStatementBinder newArgPreparedStatementBinder(Object[] args) {
        return new ArgumentPreparedStatementBinder(args);
    }

    private ReactiveSession getSession() {
        ReactiveSessionFactory sessionFactory = this.getSessionFactory();
        Assert.state((sessionFactory != null ? 1 : 0) != 0, (String)"SessionFactory is null");
        return sessionFactory.getSession();
    }

    @Nullable
    private static String getCql(@Nullable Object cqlProvider) {
        return Optional.ofNullable(cqlProvider).filter(o -> o instanceof CqlProvider).map(o -> (CqlProvider)o).map(CqlProvider::getCql).orElse(null);
    }

    class SimpleReactivePreparedStatementCreator
    implements ReactivePreparedStatementCreator,
    CqlProvider {
        private final String cql;

        SimpleReactivePreparedStatementCreator(String cql) {
            Assert.notNull((Object)cql, (String)"CQL must not be null");
            this.cql = cql;
        }

        @Override
        public Mono<PreparedStatement> createPreparedStatement(ReactiveSession session) throws DriverException {
            return session.prepare(this.cql);
        }

        @Override
        public String getCql() {
            return this.cql;
        }
    }
}

