/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.policies.RetryPolicy;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.springframework.data.cassandra.core.cql.QueryOptions;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class WriteOptions
extends QueryOptions {
    private static final WriteOptions EMPTY = new WriteOptionsBuilder().build();
    private final Duration ttl;

    @Deprecated
    public WriteOptions(@Nullable ConsistencyLevel consistencyLevel, @Nullable RetryPolicy retryPolicy) {
        this(consistencyLevel, retryPolicy, null);
    }

    @Deprecated
    public WriteOptions(@Nullable ConsistencyLevel consistencyLevel, @Nullable RetryPolicy retryPolicy, @Nullable Integer ttl) {
        super(consistencyLevel, retryPolicy);
        this.ttl = ttl == null ? Duration.ofMillis(-1L) : Duration.ofSeconds(ttl.intValue());
    }

    protected WriteOptions(@Nullable ConsistencyLevel consistencyLevel, @Nullable RetryPolicy retryPolicy, @Nullable Boolean tracing, @Nullable Integer fetchSize, Duration readTimeout, Duration ttl) {
        super(consistencyLevel, retryPolicy, tracing, fetchSize, readTimeout);
        this.ttl = ttl;
    }

    public static WriteOptions empty() {
        return EMPTY;
    }

    public static WriteOptionsBuilder builder() {
        return new WriteOptionsBuilder();
    }

    @Override
    public WriteOptionsBuilder mutate() {
        return new WriteOptionsBuilder(this);
    }

    public Duration getTtl() {
        return this.ttl;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WriteOptions)) {
            return false;
        }
        WriteOptions other = (WriteOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Duration this$ttl = this.getTtl();
        Duration other$ttl = other.getTtl();
        return !(this$ttl == null ? other$ttl != null : !((Object)this$ttl).equals(other$ttl));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof WriteOptions;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        Duration $ttl = this.getTtl();
        result = result * 59 + ($ttl == null ? 43 : ((Object)$ttl).hashCode());
        return result;
    }

    public static class WriteOptionsBuilder
    extends QueryOptions.QueryOptionsBuilder {
        protected Duration ttl = Duration.ofMillis(-1L);

        protected WriteOptionsBuilder() {
        }

        protected WriteOptionsBuilder(WriteOptions writeOptions) {
            super(writeOptions);
            this.ttl = writeOptions.ttl;
        }

        @Override
        public WriteOptionsBuilder consistencyLevel(ConsistencyLevel consistencyLevel) {
            return (WriteOptionsBuilder)super.consistencyLevel(consistencyLevel);
        }

        @Override
        public WriteOptionsBuilder retryPolicy(RetryPolicy driverRetryPolicy) {
            return (WriteOptionsBuilder)super.retryPolicy(driverRetryPolicy);
        }

        @Override
        public WriteOptionsBuilder fetchSize(int fetchSize) {
            return (WriteOptionsBuilder)super.fetchSize(fetchSize);
        }

        @Override
        public WriteOptionsBuilder readTimeout(long readTimeout) {
            return (WriteOptionsBuilder)super.readTimeout(readTimeout);
        }

        @Override
        @Deprecated
        public WriteOptionsBuilder readTimeout(long readTimeout, TimeUnit timeUnit) {
            return (WriteOptionsBuilder)super.readTimeout(readTimeout, timeUnit);
        }

        @Override
        public WriteOptionsBuilder readTimeout(Duration readTimeout) {
            return (WriteOptionsBuilder)super.readTimeout(readTimeout);
        }

        @Override
        public WriteOptionsBuilder tracing(boolean tracing) {
            return (WriteOptionsBuilder)super.tracing(tracing);
        }

        @Override
        public WriteOptionsBuilder withTracing() {
            return (WriteOptionsBuilder)super.withTracing();
        }

        public WriteOptionsBuilder ttl(int ttl) {
            Assert.isTrue((ttl >= 0 ? 1 : 0) != 0, (String)"TTL must be greater than equal to zero");
            this.ttl = Duration.ofSeconds(ttl);
            return this;
        }

        public WriteOptionsBuilder ttl(Duration ttl) {
            Assert.notNull((Object)ttl, (String)"TTL must not be null");
            Assert.isTrue((!ttl.isNegative() ? 1 : 0) != 0, (String)"TTL must be greater than equal to zero");
            this.ttl = ttl;
            return this;
        }

        @Override
        public WriteOptions build() {
            return new WriteOptions(this.consistencyLevel, this.retryPolicy, this.tracing, this.fetchSize, this.readTimeout, this.ttl);
        }
    }
}

