/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.config;

import com.datastax.driver.core.Session;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.cassandra.convert.CassandraConverter;
import org.springframework.data.cassandra.core.CassandraTemplate;
import org.springframework.util.Assert;

public class CassandraTemplateFactoryBean
implements FactoryBean<CassandraTemplate>,
InitializingBean {
    protected Session session;
    protected CassandraConverter converter;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.session, (String)"Session must not be null");
        Assert.notNull((Object)this.converter, (String)"Converter must not be null");
    }

    public CassandraTemplate getObject() throws Exception {
        return new CassandraTemplate(this.session, this.converter);
    }

    public Class<CassandraTemplate> getObjectType() {
        return CassandraTemplate.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setSession(Session session) {
        Assert.notNull((Object)session, (String)"Session must not be null");
        this.session = session;
    }

    public void setConverter(CassandraConverter converter) {
        Assert.notNull((Object)converter, (String)"Converter must not be null");
        this.converter = converter;
    }
}

