/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.support;

import java.lang.reflect.Method;
import java.util.Arrays;

class Signature {
    String name;
    Class<?>[] argTypes;
    Class<?> returnType;

    Signature(Method method, boolean includeReturnType) {
        this(method.getName(), method.getParameterTypes(), includeReturnType ? method.getReturnType() : null);
    }

    Signature(String name, Class<?>[] argTypes, Class<?> returnType) {
        this.name = name;
        this.argTypes = argTypes;
        this.returnType = returnType;
    }

    public String toString() {
        return String.format("%s %s(%s)", this.returnType, this.name, Arrays.toString(this.argTypes));
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        if (!(that instanceof Signature)) {
            return false;
        }
        Signature that_ = (Signature)that;
        if (!this.name.equals(that_.name)) {
            return false;
        }
        if (this.argTypes == null && that_.argTypes != null || this.argTypes != null && that_.argTypes == null) {
            return false;
        }
        if (this.argTypes != null) {
            if (this.argTypes.length != that_.argTypes.length) {
                return false;
            }
            for (int i = 0; i < this.argTypes.length; ++i) {
                if (this.argTypes[i].equals(that_.argTypes[i])) continue;
                return false;
            }
        }
        if (this.returnType == null) {
            return that_.returnType == null;
        }
        return this.returnType.equals(that_.returnType);
    }

    public int hashCode() {
        int hash = 0x25 ^ this.name.hashCode();
        if (this.argTypes != null) {
            for (Class<?> c : this.argTypes) {
                hash ^= c.hashCode();
            }
        }
        if (this.returnType != null) {
            hash ^= this.returnType.hashCode();
        }
        return hash;
    }
}

