/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.mapping;

import java.util.ArrayList;
import java.util.List;
import org.springframework.data.annotation.Id;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntityMetadataVerifier;
import org.springframework.data.cassandra.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.mapping.PrimaryKeyClass;
import org.springframework.data.cassandra.mapping.PrimaryKeyColumn;
import org.springframework.data.cassandra.mapping.Table;
import org.springframework.data.cassandra.mapping.VerifierMappingExceptions;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.model.MappingException;

public class BasicCassandraPersistentEntityMetadataVerifier
implements CassandraPersistentEntityMetadataVerifier {
    @Deprecated
    protected boolean strict = false;

    @Override
    public void verify(CassandraPersistentEntity<?> entity) throws MappingException {
        if (entity.getType().isInterface() || entity.findAnnotation(Table.class) == null) {
            return;
        }
        ArrayList<MappingException> exceptions = new ArrayList<MappingException>();
        final ArrayList idProperties = new ArrayList();
        final ArrayList partitionKeyColumns = new ArrayList();
        final ArrayList primaryKeyColumns = new ArrayList();
        if (entity.isCompositePrimaryKey()) {
            exceptions.add(new MappingException(String.format("Entity cannot be of type @%s and @%s", Table.class.getSimpleName(), PrimaryKeyClass.class.getSimpleName())));
        }
        entity.doWithProperties((PropertyHandler)new PropertyHandler<CassandraPersistentProperty>(){

            public void doWithPersistentProperty(CassandraPersistentProperty property) {
                if (property.isIdProperty()) {
                    idProperties.add(property);
                } else if (property.isClusterKeyColumn()) {
                    primaryKeyColumns.add(property);
                } else if (property.isPartitionKeyColumn()) {
                    partitionKeyColumns.add(property);
                    primaryKeyColumns.add(property);
                }
            }
        });
        if (primaryKeyColumns.isEmpty() && idProperties.size() != 1) {
            exceptions.add(new MappingException(String.format("@%s types must have only one primary attribute, if any; Found %s", Table.class.getSimpleName(), idProperties.size())));
            BasicCassandraPersistentEntityMetadataVerifier.fail(entity, exceptions);
        }
        if (!idProperties.isEmpty() && !primaryKeyColumns.isEmpty()) {
            exceptions.add(new MappingException(String.format("@%s types must not define both @%s and @%s properties", Table.class.getSimpleName(), Id.class.getSimpleName(), PrimaryKeyColumn.class.getSimpleName())));
            BasicCassandraPersistentEntityMetadataVerifier.fail(entity, exceptions);
        }
        if (!primaryKeyColumns.isEmpty() && partitionKeyColumns.isEmpty()) {
            exceptions.add(new MappingException(String.format("At least one of the @%s annotations must have a type of PARTITIONED", PrimaryKeyColumn.class.getSimpleName())));
        }
        if (!exceptions.isEmpty()) {
            BasicCassandraPersistentEntityMetadataVerifier.fail(entity, exceptions);
        }
    }

    @Deprecated
    public boolean isStrict() {
        return this.strict;
    }

    @Deprecated
    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    private static void fail(CassandraPersistentEntity<?> entity, List<MappingException> exceptions) {
        throw new VerifierMappingExceptions(entity, exceptions);
    }
}

