/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.querybuilder.BindMarker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.data.cassandra.repository.query.AbstractCassandraQuery;
import org.springframework.data.cassandra.repository.query.CassandraParameterAccessor;
import org.springframework.data.cassandra.repository.query.CassandraQueryMethod;
import org.springframework.data.cassandra.repository.query.ExpressionEvaluatingParameterBinder;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.QueryCreationException;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class StringBasedCassandraQuery
extends AbstractCassandraQuery {
    private static final Logger LOG = LoggerFactory.getLogger(StringBasedCassandraQuery.class);
    private static final ParameterBindingParser BINDING_PARSER = ParameterBindingParser.INSTANCE;
    private final CodecRegistry codecRegistry;
    private final ExpressionEvaluatingParameterBinder parameterBinder;
    private final List<ParameterBinding> queryParameterBindings = new ArrayList<ParameterBinding>();
    private final String query;

    public StringBasedCassandraQuery(CassandraQueryMethod queryMethod, CassandraOperations operations, SpelExpressionParser expressionParser, EvaluationContextProvider evaluationContextProvider) {
        this(queryMethod.getAnnotatedQuery(), queryMethod, operations, expressionParser, evaluationContextProvider);
    }

    public StringBasedCassandraQuery(String query, CassandraQueryMethod queryMethod, CassandraOperations operations, SpelExpressionParser expressionParser, EvaluationContextProvider evaluationContextProvider) {
        super(queryMethod, operations);
        this.query = BINDING_PARSER.parseAndCollectParameterBindingsFromQueryIntoBindings(query, this.queryParameterBindings);
        this.parameterBinder = new ExpressionEvaluatingParameterBinder(expressionParser, evaluationContextProvider);
        this.codecRegistry = operations.getSession().getCluster().getConfiguration().getCodecRegistry();
    }

    @Override
    public String createQuery(CassandraParameterAccessor parameterAccessor) {
        try {
            List<Object> arguments = this.parameterBinder.bind(parameterAccessor, new ExpressionEvaluatingParameterBinder.BindingContext(this.getQueryMethod(), this.queryParameterBindings));
            String boundQuery = this.bind(this.query, arguments);
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Created query [%s].", boundQuery));
            }
            return boundQuery;
        }
        catch (RuntimeException e) {
            throw QueryCreationException.create((QueryMethod)this.getQueryMethod(), (Throwable)e);
        }
    }

    private String bind(String query, List<Object> arguments) {
        return ParameterBinder.INSTANCE.bind(query, this.codecRegistry, arguments);
    }

    static class ParameterBinding {
        private final boolean quoted;
        private final int parameterIndex;
        private final String expression;
        private final String parameterName;

        private ParameterBinding(int parameterIndex, boolean quoted, String expression, String parameterName) {
            this.parameterIndex = parameterIndex;
            this.quoted = quoted;
            this.expression = expression;
            this.parameterName = parameterName;
        }

        public static ParameterBinding expression(String expression, boolean quoted) {
            return new ParameterBinding(-1, quoted, expression, null);
        }

        public static ParameterBinding indexed(int parameterIndex) {
            return new ParameterBinding(parameterIndex, false, null, null);
        }

        public static ParameterBinding named(String name) {
            return new ParameterBinding(-1, false, null, name);
        }

        public boolean isNamed() {
            return this.parameterName != null;
        }

        public int getParameterIndex() {
            return this.parameterIndex;
        }

        public String getParameter() {
            return "?" + (this.isExpression() ? "expr" : "") + this.parameterIndex;
        }

        public String getExpression() {
            return this.expression;
        }

        public boolean isExpression() {
            return this.expression != null;
        }

        public String getParameterName() {
            return this.parameterName;
        }
    }

    static enum ParameterBindingParser {
        INSTANCE;

        private static final char CURRLY_BRACE_OPEN = '{';
        private static final char CURRLY_BRACE_CLOSE = '}';
        private static final Pattern INDEX_PARAMETER_BINDING_PATTERN;
        private static final Pattern NAMED_PARAMETER_BINDING_PATTERN;
        private static final Pattern INDEX_BASED_EXPRESSION_PATTERN;
        private static final Pattern NAME_BASED_EXPRESSION_PATTERN;
        private static final String ARGUMENT_PLACEHOLDER = "?_param_?";

        public String parseAndCollectParameterBindingsFromQueryIntoBindings(String input, List<ParameterBinding> bindings) {
            if (!StringUtils.hasText((String)input)) {
                return input;
            }
            Assert.notNull(bindings, (String)"Parameter bindings must not be null");
            return ParameterBindingParser.transformQueryAndCollectExpressionParametersIntoBindings(input, bindings);
        }

        private static String transformQueryAndCollectExpressionParametersIntoBindings(String input, List<ParameterBinding> bindings) {
            Matcher matcher;
            StringBuilder result = new StringBuilder();
            int startIndex = 0;
            int currentPosition = 0;
            while (currentPosition < input.length() && (matcher = ParameterBindingParser.findNextBindingOrExpression(input, currentPosition)) != null) {
                int exprStart;
                currentPosition = exprStart = matcher.start();
                if (matcher.pattern() == NAME_BASED_EXPRESSION_PATTERN || matcher.pattern() == INDEX_BASED_EXPRESSION_PATTERN) {
                    int curlyBraceOpenCount = 1;
                    currentPosition += 3;
                    block5: while (curlyBraceOpenCount > 0 && currentPosition < input.length()) {
                        switch (input.charAt(currentPosition++)) {
                            case '{': {
                                ++curlyBraceOpenCount;
                                continue block5;
                            }
                            case '}': {
                                --curlyBraceOpenCount;
                                continue block5;
                            }
                        }
                    }
                    result.append(input.subSequence(startIndex, exprStart));
                } else {
                    result.append(input.subSequence(startIndex, exprStart));
                }
                result.append(ARGUMENT_PLACEHOLDER);
                if (matcher.pattern() == NAME_BASED_EXPRESSION_PATTERN || matcher.pattern() == INDEX_BASED_EXPRESSION_PATTERN) {
                    bindings.add(ParameterBinding.expression(input.substring(exprStart + 3, currentPosition - 1), true));
                } else {
                    if (matcher.pattern() == INDEX_PARAMETER_BINDING_PATTERN) {
                        bindings.add(ParameterBinding.indexed(Integer.parseInt(matcher.group(1))));
                    } else {
                        bindings.add(ParameterBinding.named(matcher.group(1)));
                    }
                    currentPosition = matcher.end();
                }
                startIndex = currentPosition;
            }
            return result.append(input.subSequence(currentPosition, input.length())).toString();
        }

        private static Matcher findNextBindingOrExpression(String input, int position) {
            ArrayList<Matcher> matchers = new ArrayList<Matcher>();
            matchers.add(INDEX_PARAMETER_BINDING_PATTERN.matcher(input));
            matchers.add(NAMED_PARAMETER_BINDING_PATTERN.matcher(input));
            matchers.add(INDEX_BASED_EXPRESSION_PATTERN.matcher(input));
            matchers.add(NAME_BASED_EXPRESSION_PATTERN.matcher(input));
            TreeMap<Integer, Matcher> matcherMap = new TreeMap<Integer, Matcher>();
            for (Matcher matcher : matchers) {
                if (!matcher.find(position)) continue;
                matcherMap.put(matcher.start(), matcher);
            }
            return matcherMap.isEmpty() ? null : (Matcher)matcherMap.values().iterator().next();
        }

        static {
            INDEX_PARAMETER_BINDING_PATTERN = Pattern.compile("\\?(\\d+)");
            NAMED_PARAMETER_BINDING_PATTERN = Pattern.compile("\\:(\\w+)");
            INDEX_BASED_EXPRESSION_PATTERN = Pattern.compile("\\?\\#\\{");
            NAME_BASED_EXPRESSION_PATTERN = Pattern.compile("\\:\\#\\{");
        }
    }

    static enum ParameterBinder {
        INSTANCE;

        private static final String ARGUMENT_PLACEHOLDER = "?_param_?";
        private static final Pattern ARGUMENT_PLACEHOLDER_PATTERN;

        public String bind(String input, CodecRegistry codecRegistry, List<Object> parameters) {
            if (parameters.isEmpty()) {
                return input;
            }
            StringBuilder result = new StringBuilder();
            int startIndex = 0;
            int currentPosition = 0;
            int parameterIndex = 0;
            Matcher matcher = ARGUMENT_PLACEHOLDER_PATTERN.matcher(input);
            while (currentPosition < input.length() && matcher.find()) {
                int exprStart = matcher.start();
                result.append(input.subSequence(startIndex, exprStart));
                result = ParameterBinder.appendValue(parameters.get(parameterIndex++), codecRegistry, result);
                startIndex = currentPosition = matcher.end();
            }
            return result.append(input.subSequence(currentPosition, input.length())).toString();
        }

        static StringBuilder appendValue(Object value, CodecRegistry codecRegistry, StringBuilder builder) {
            if (value == null) {
                builder.append("null");
            } else if (value instanceof BindMarker) {
                builder.append(value);
            } else if (value instanceof List && ParameterBinder.isSerializable(value)) {
                ParameterBinder.appendList((List)value, codecRegistry, builder);
            } else if (value instanceof Set && ParameterBinder.isSerializable(value)) {
                ParameterBinder.appendSet((Set)value, codecRegistry, builder);
            } else if (value instanceof Map && ParameterBinder.isSerializable(value)) {
                ParameterBinder.appendMap((Map)value, codecRegistry, builder);
            } else if (ParameterBinder.isSerializable(value)) {
                TypeCodec codec = codecRegistry.codecFor(value);
                builder.append(codec.format(value));
            } else {
                throw new IllegalArgumentException(String.format("Argument value [%s] is not serializable", value.toString()));
            }
            return builder;
        }

        private static StringBuilder appendList(List<?> list, CodecRegistry codecRegistry, StringBuilder builder) {
            int size = list.size();
            for (int index = 0; index < size; ++index) {
                builder.append(index > 0 ? "," : "");
                ParameterBinder.appendValue(list.get(index), codecRegistry, builder);
            }
            return builder;
        }

        private static StringBuilder appendSet(Set<?> set, CodecRegistry codecRegistry, StringBuilder builder) {
            boolean first = true;
            for (Object element : set) {
                builder.append(first ? "" : ",");
                ParameterBinder.appendValue(element, codecRegistry, builder);
                first = false;
            }
            return builder;
        }

        private static StringBuilder appendMap(Map<?, ?> map, CodecRegistry codecRegistry, StringBuilder builder) {
            builder.append('{');
            boolean first = true;
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                builder.append(first ? "" : ",");
                ParameterBinder.appendValue(entry.getKey(), codecRegistry, builder);
                builder.append(':');
                ParameterBinder.appendValue(entry.getValue(), codecRegistry, builder);
                first = false;
            }
            builder.append('}');
            return builder;
        }

        static boolean isSerializable(Object value) {
            if (ParameterBinder.containsSpecialValue(value)) {
                return false;
            }
            if (value instanceof Collection) {
                for (Object e : (Collection)value) {
                    if (ParameterBinder.isSerializable(e)) continue;
                    return false;
                }
            }
            if (value instanceof Map) {
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    if (ParameterBinder.isSerializable(entry.getKey()) && ParameterBinder.isSerializable(entry.getValue())) continue;
                    return false;
                }
            }
            return true;
        }

        static boolean containsSpecialValue(Object value) {
            if (value instanceof BindMarker) {
                return true;
            }
            if (value instanceof Collection) {
                for (Object e : (Collection)value) {
                    if (!ParameterBinder.containsSpecialValue(e)) continue;
                    return true;
                }
            }
            if (value instanceof Map) {
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    if (!ParameterBinder.containsSpecialValue(entry.getKey()) && !ParameterBinder.containsSpecialValue(entry.getValue())) continue;
                    return true;
                }
            }
            return false;
        }

        static {
            ARGUMENT_PLACEHOLDER_PATTERN = Pattern.compile(Pattern.quote(ARGUMENT_PLACEHOLDER));
        }
    }
}

