/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.mapping;

import com.datastax.driver.core.TableMetadata;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.cassandra.core.cql.CqlIdentifier;
import org.springframework.cassandra.core.keyspace.CreateTableSpecification;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.cassandra.mapping.BasicCassandraPersistentEntity;
import org.springframework.data.cassandra.mapping.BasicCassandraPersistentEntityMetadataVerifier;
import org.springframework.data.cassandra.mapping.BasicCassandraPersistentProperty;
import org.springframework.data.cassandra.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntityMetadataVerifier;
import org.springframework.data.cassandra.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.mapping.CassandraSimpleTypeHolder;
import org.springframework.data.cassandra.mapping.EntityMapping;
import org.springframework.data.cassandra.mapping.Mapping;
import org.springframework.data.cassandra.mapping.PropertyMapping;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.context.AbstractMappingContext;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class BasicCassandraMappingContext
extends AbstractMappingContext<CassandraPersistentEntity<?>, CassandraPersistentProperty>
implements CassandraMappingContext,
ApplicationContextAware {
    protected ApplicationContext context;
    protected ClassLoader beanClassLoader;
    protected CassandraPersistentEntityMetadataVerifier verifier = new BasicCassandraPersistentEntityMetadataVerifier();
    protected Mapping mapping = new Mapping();
    protected Map<Class<?>, CassandraPersistentEntity<?>> entitiesByType = new HashMap();
    protected Map<CqlIdentifier, Set<CassandraPersistentEntity<?>>> entitySetsByTableName = new HashMap();
    protected Set<CassandraPersistentEntity<?>> nonPrimaryKeyEntities = new HashSet();
    protected Set<CassandraPersistentEntity<?>> primaryKeyEntities = new HashSet();

    public BasicCassandraMappingContext() {
        this.setSimpleTypeHolder(new CassandraSimpleTypeHolder());
    }

    public void initialize() {
        super.initialize();
        this.processMappingOverrides();
    }

    @Override
    public Collection<CassandraPersistentEntity<?>> getPersistentEntities() {
        return this.getPersistentEntities(false);
    }

    @Override
    public Collection<CassandraPersistentEntity<?>> getPrimaryKeyEntities() {
        return Collections.unmodifiableSet(this.primaryKeyEntities);
    }

    @Override
    public Collection<CassandraPersistentEntity<?>> getNonPrimaryKeyEntities() {
        return Collections.unmodifiableSet(this.nonPrimaryKeyEntities);
    }

    @Override
    public Collection<CassandraPersistentEntity<?>> getPersistentEntities(boolean includePrimaryKeyTypes) {
        if (includePrimaryKeyTypes) {
            return super.getPersistentEntities();
        }
        return Collections.unmodifiableSet(this.nonPrimaryKeyEntities);
    }

    public CassandraPersistentProperty createPersistentProperty(Field field, PropertyDescriptor descriptor, CassandraPersistentEntity<?> owner, SimpleTypeHolder simpleTypeHolder) {
        return this.createPersistentProperty(field, descriptor, owner, (CassandraSimpleTypeHolder)simpleTypeHolder);
    }

    public CassandraPersistentProperty createPersistentProperty(Field field, PropertyDescriptor descriptor, CassandraPersistentEntity<?> owner, CassandraSimpleTypeHolder simpleTypeHolder) {
        return new BasicCassandraPersistentProperty(field, descriptor, owner, simpleTypeHolder);
    }

    protected <T> CassandraPersistentEntity<T> createPersistentEntity(TypeInformation<T> typeInformation) {
        Set<CassandraPersistentEntity<?>> entities;
        BasicCassandraPersistentEntity<T> entity = new BasicCassandraPersistentEntity<T>(typeInformation, this, this.verifier);
        if (this.context != null) {
            entity.setApplicationContext(this.context);
        }
        if ((entities = this.entitySetsByTableName.get(entity.getTableName())) == null) {
            entities = new HashSet();
        }
        entities.add(entity);
        this.entitySetsByTableName.put(entity.getTableName(), entities);
        if (entity.isCompositePrimaryKey()) {
            this.primaryKeyEntities.add(entity);
        } else {
            this.nonPrimaryKeyEntities.add(entity);
        }
        this.entitiesByType.put(entity.getType(), entity);
        return entity;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    @Override
    public boolean usesTable(TableMetadata table) {
        return this.entitySetsByTableName.containsKey(CqlIdentifier.cqlId((CharSequence)table.getName()));
    }

    @Override
    public CreateTableSpecification getCreateTableSpecificationFor(CassandraPersistentEntity<?> entity) {
        Assert.notNull(entity);
        final CreateTableSpecification spec = CreateTableSpecification.createTable().name(entity.getTableName());
        entity.doWithProperties((PropertyHandler)new PropertyHandler<CassandraPersistentProperty>(){

            public void doWithPersistentProperty(CassandraPersistentProperty prop) {
                if (prop.isCompositePrimaryKey()) {
                    CassandraPersistentEntity pkEntity = (CassandraPersistentEntity)BasicCassandraMappingContext.this.getPersistentEntity(prop.getRawType());
                    pkEntity.doWithProperties((PropertyHandler)new PropertyHandler<CassandraPersistentProperty>(){

                        public void doWithPersistentProperty(CassandraPersistentProperty pkProp) {
                            if (pkProp.isPartitionKeyColumn()) {
                                spec.partitionKeyColumn(pkProp.getColumnName(), pkProp.getDataType());
                            } else {
                                spec.clusteredKeyColumn(pkProp.getColumnName(), pkProp.getDataType(), pkProp.getPrimaryKeyOrdering());
                            }
                        }
                    });
                } else if (prop.isIdProperty() || prop.isPartitionKeyColumn()) {
                    spec.partitionKeyColumn(prop.getColumnName(), prop.getDataType());
                } else if (prop.isClusterKeyColumn()) {
                    spec.clusteredKeyColumn(prop.getColumnName(), prop.getDataType());
                } else {
                    spec.column(prop.getColumnName(), prop.getDataType());
                }
            }
        });
        if (spec.getPartitionKeyColumns().isEmpty()) {
            throw new MappingException("no partition key columns found in the entity " + entity.getType());
        }
        return spec;
    }

    public void setMapping(Mapping mapping) {
        Assert.notNull((Object)mapping);
        this.mapping = mapping;
    }

    protected void processMappingOverrides() {
        if (this.mapping == null) {
            return;
        }
        for (EntityMapping entityMapping : this.mapping.getEntityMappings()) {
            Class entityClass;
            if (entityMapping == null) continue;
            String entityClassName = entityMapping.getEntityClassName();
            try {
                entityClass = ClassUtils.forName((String)entityClassName, (ClassLoader)this.beanClassLoader);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(String.format("unknown persistent entity name [%s]", entityClassName), e);
            }
            CassandraPersistentEntity entity = (CassandraPersistentEntity)this.getPersistentEntity(entityClass);
            if (entity == null) {
                throw new IllegalStateException(String.format("unknown persistent entity class name [%s]", entityClassName));
            }
            String tableName = entityMapping.getTableName();
            if (StringUtils.hasText((String)tableName)) {
                entity.setTableName(CqlIdentifier.cqlId((CharSequence)tableName, (boolean)Boolean.valueOf(entityMapping.getForceQuote())));
            }
            this.processMappingOverrides(entity, entityMapping);
        }
    }

    protected void processMappingOverrides(CassandraPersistentEntity<?> entity, EntityMapping entityMapping) {
        for (PropertyMapping mapping : entityMapping.getPropertyMappings().values()) {
            this.processMappingOverride(entity, mapping);
        }
    }

    protected void processMappingOverride(CassandraPersistentEntity<?> entity, PropertyMapping mapping) {
        CassandraPersistentProperty property = (CassandraPersistentProperty)entity.getPersistentProperty(mapping.getPropertyName());
        if (property == null) {
            throw new IllegalArgumentException(String.format("entity class [%s] has no persistent property named [%s]", entity.getType().getName(), mapping.getPropertyName()));
        }
        boolean forceQuote = false;
        String value = mapping.getForceQuote();
        if (StringUtils.hasText((String)value)) {
            forceQuote = Boolean.valueOf(value);
            property.setForceQuote(forceQuote);
        }
        if (StringUtils.hasText((String)(value = mapping.getColumnName()))) {
            property.setColumnName(CqlIdentifier.cqlId((CharSequence)value, (boolean)forceQuote));
        }
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    @Override
    public CassandraPersistentEntity<?> getExistingPersistentEntity(Class<?> type) {
        CassandraPersistentEntity<?> entity = this.entitiesByType.get(type);
        if (entity != null) {
            return entity;
        }
        throw new IllegalArgumentException(String.format("unknown persistent type [%s]", type.getName()));
    }

    @Override
    public boolean contains(Class<?> type) {
        return this.entitiesByType.containsKey(type);
    }

    public CassandraPersistentEntityMetadataVerifier getVerifier() {
        return this.verifier;
    }

    @Override
    public void setVerifier(CassandraPersistentEntityMetadataVerifier verifier) {
        this.verifier = verifier;
    }
}

