/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.ProcessBean;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.data.cassandra.repository.cdi.CassandraRepositoryBean;
import org.springframework.data.repository.cdi.CdiRepositoryBean;
import org.springframework.data.repository.cdi.CdiRepositoryExtensionSupport;

public class CassandraRepositoryExtension
extends CdiRepositoryExtensionSupport {
    private final Map<String, Bean<CassandraOperations>> cassandraOperationsMap = new HashMap<String, Bean<CassandraOperations>>();

    <T> void processBean(@Observes ProcessBean<T> processBean) {
        Bean bean = processBean.getBean();
        for (Type type : bean.getTypes()) {
            if (!(type instanceof Class) || !CassandraOperations.class.isAssignableFrom((Class)type)) continue;
            this.cassandraOperationsMap.put(bean.getQualifiers().toString(), (Bean<CassandraOperations>)bean);
        }
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        for (Map.Entry entry : this.getRepositoryTypes()) {
            Class repositoryType = (Class)entry.getKey();
            Set qualifiers = (Set)entry.getValue();
            CdiRepositoryBean repositoryBean = this.createRepositoryBean(repositoryType, qualifiers, beanManager);
            afterBeanDiscovery.addBean(repositoryBean);
            this.registerBean(repositoryBean);
        }
    }

    private <T> CdiRepositoryBean<T> createRepositoryBean(Class<T> repositoryType, Set<Annotation> qualifiers, BeanManager beanManager) {
        Bean<CassandraOperations> cassandraOperationsBean = this.cassandraOperationsMap.get(qualifiers.toString());
        if (cassandraOperationsBean == null) {
            throw new UnsatisfiedResolutionException(String.format("Unable to resolve a bean for '%s' with qualifiers %s.", CassandraOperations.class.getName(), qualifiers));
        }
        return new CassandraRepositoryBean<T>(cassandraOperationsBean, qualifiers, repositoryType, beanManager, this.getCustomImplementationDetector());
    }
}

