/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import com.datastax.driver.core.querybuilder.Select;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.data.cassandra.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.repository.query.AbstractCassandraQuery;
import org.springframework.data.cassandra.repository.query.CassandraParameterAccessor;
import org.springframework.data.cassandra.repository.query.CassandraQueryCreator;
import org.springframework.data.cassandra.repository.query.CassandraQueryMethod;
import org.springframework.data.repository.query.parser.PartTree;

public class PartTreeCassandraQuery
extends AbstractCassandraQuery {
    private final PartTree tree;
    private final CassandraMappingContext context;

    public PartTreeCassandraQuery(CassandraQueryMethod method, CassandraOperations cassandraOperations) {
        super(method, cassandraOperations);
        this.tree = new PartTree(method.getName(), method.getEntityInformation().getJavaType());
        this.context = cassandraOperations.getConverter().getMappingContext();
    }

    public PartTree getTree() {
        return this.tree;
    }

    @Override
    protected String createQuery(CassandraParameterAccessor accessor) {
        CassandraQueryCreator creator = new CassandraQueryCreator(this.tree, accessor, this.context);
        return ((Select)creator.createQuery()).getQueryString();
    }
}

