/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.config.java;

import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.cassandra.config.java.AbstractClusterConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.cassandra.config.CassandraEntityClassScanner;
import org.springframework.data.cassandra.config.CassandraSessionFactoryBean;
import org.springframework.data.cassandra.config.SchemaAction;
import org.springframework.data.cassandra.convert.CassandraConverter;
import org.springframework.data.cassandra.convert.MappingCassandraConverter;
import org.springframework.data.cassandra.core.CassandraAdminOperations;
import org.springframework.data.cassandra.core.CassandraAdminTemplate;
import org.springframework.data.cassandra.mapping.BasicCassandraMappingContext;
import org.springframework.data.cassandra.mapping.CassandraMappingContext;

@Configuration
public abstract class AbstractCassandraConfiguration
extends AbstractClusterConfiguration
implements BeanClassLoaderAware {
    protected ClassLoader beanClassLoader;

    protected abstract String getKeyspaceName();

    public SchemaAction getSchemaAction() {
        return SchemaAction.NONE;
    }

    public String[] getEntityBasePackages() {
        return new String[]{((Object)((Object)this)).getClass().getPackage().getName()};
    }

    @Bean
    public CassandraSessionFactoryBean session() throws Exception {
        CassandraSessionFactoryBean bean = new CassandraSessionFactoryBean();
        bean.setCluster(this.cluster().getObject());
        bean.setConverter(this.cassandraConverter());
        bean.setSchemaAction(this.getSchemaAction());
        bean.setKeyspaceName(this.getKeyspaceName());
        bean.setStartupScripts(this.getStartupScripts());
        bean.setShutdownScripts(this.getShutdownScripts());
        return bean;
    }

    @Bean
    public CassandraAdminOperations cassandraTemplate() throws Exception {
        return new CassandraAdminTemplate(this.session().getObject(), this.cassandraConverter());
    }

    @Bean
    public CassandraMappingContext cassandraMapping() throws ClassNotFoundException {
        BasicCassandraMappingContext bean = new BasicCassandraMappingContext();
        bean.setInitialEntitySet(CassandraEntityClassScanner.scan(this.getEntityBasePackages()));
        bean.setBeanClassLoader(this.beanClassLoader);
        return bean;
    }

    @Bean
    public CassandraConverter cassandraConverter() throws Exception {
        return new MappingCassandraConverter(this.cassandraMapping());
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }
}

