/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.config;

import org.springframework.util.StringUtils;

public class BeanDefinitionBuilderArgument {
    protected boolean reference;
    protected Object value;

    public static BeanDefinitionBuilderArgument ref(CharSequence value) {
        return new BeanDefinitionBuilderArgument(true, value);
    }

    public static BeanDefinitionBuilderArgument val(Object value) {
        return new BeanDefinitionBuilderArgument(false, value);
    }

    protected BeanDefinitionBuilderArgument(boolean reference, Object value) {
        this.reference = reference;
        if (this.reference && (value == null || !(value instanceof CharSequence))) {
            throw new IllegalArgumentException(String.format("reference argument must have value of type CharSequence, not [%s]", value == null ? "null" : value.getClass().getName()));
        }
        if (!StringUtils.hasText((CharSequence)((CharSequence)value))) {
            throw new IllegalArgumentException("given CharSequence has no text");
        }
        this.value = value;
    }

    public boolean isReference() {
        return this.reference;
    }

    public Object getValue() {
        return this.value;
    }
}

