/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.mapping;

import java.util.Collection;
import java.util.LinkedList;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntity;
import org.springframework.data.mapping.model.MappingException;

public class VerifierMappingExceptions
extends MappingException {
    Collection<MappingException> exceptions = new LinkedList<MappingException>();
    private String className;

    public VerifierMappingExceptions(CassandraPersistentEntity<?> entity, String s) {
        super(s);
        this.className = entity.getType().getName();
    }

    public void add(MappingException e) {
        this.exceptions.add(e);
    }

    public Collection<MappingException> getMappingExceptions() {
        return this.exceptions;
    }

    public Collection<String> getMessages() {
        LinkedList<String> messages = new LinkedList<String>();
        for (MappingException e : this.exceptions) {
            messages.add(e.getMessage());
        }
        return messages;
    }

    public int getCount() {
        return this.exceptions.size();
    }

    public String getMessage() {
        StringBuilder builder = new StringBuilder(this.className).append(":\n");
        for (MappingException e : this.exceptions) {
            builder.append(e.getMessage()).append("\n");
        }
        return builder.toString();
    }
}

