/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.config;

import com.datastax.driver.core.Session;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.data.cassandra.config.BeanDefinitionUtils;
import org.springframework.data.cassandra.config.CassandraSessionFactoryBean;
import org.springframework.data.cassandra.convert.CassandraConverter;
import org.springframework.data.cassandra.convert.MappingCassandraConverter;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.data.cassandra.core.CassandraTemplate;
import org.springframework.data.cassandra.mapping.BasicCassandraMappingContext;
import org.springframework.data.cassandra.mapping.CassandraMappingContext;
import org.springframework.util.StringUtils;

public class CassandraMappingBeanFactoryPostProcessor
implements BeanDefinitionRegistryPostProcessor {
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        if (!(registry instanceof ListableBeanFactory)) {
            return;
        }
        ListableBeanFactory factory = (ListableBeanFactory)registry;
        this.registerMissingDefaultableBeanDefinitions(registry, factory);
    }

    protected void registerMissingDefaultableBeanDefinitions(BeanDefinitionRegistry registry, ListableBeanFactory factory) {
        BeanDefinitionHolder contextBean;
        BeanDefinitionHolder[] templateBeans = BeanDefinitionUtils.getBeanDefinitionsOfType(registry, factory, CassandraOperations.class, true, false);
        if (templateBeans.length >= 1) {
            return;
        }
        String sessionBeanName = this.findSessionBeanName(registry, factory);
        BeanDefinitionHolder[] converterBeans = BeanDefinitionUtils.getBeanDefinitionsOfType(registry, factory, MappingCassandraConverter.class, true, false);
        if (converterBeans.length == 1) {
            this.registerDefaultTemplate(registry, sessionBeanName, converterBeans[0].getBeanName());
            return;
        }
        if (converterBeans.length > 1) {
            throw new IllegalStateException(String.format("found %d beans of type [%s] - can't disambiguate for creation of [%s]", converterBeans.length, CassandraConverter.class.getName(), CassandraTemplate.class.getName()));
        }
        BeanDefinitionHolder[] contextBeans = BeanDefinitionUtils.getBeanDefinitionsOfType(registry, factory, CassandraMappingContext.class, true, false);
        if (contextBeans.length > 1) {
            throw new IllegalStateException(String.format("found %d beans of type [%s] - can't disambiguate for creation of [%s]", contextBeans.length, CassandraMappingContext.class.getName(), MappingCassandraConverter.class.getName()));
        }
        BeanDefinitionHolder beanDefinitionHolder = contextBean = contextBeans.length == 1 ? contextBeans[0] : null;
        if (contextBean == null) {
            contextBean = this.regsiterDefaultContext(registry);
        }
        BeanDefinitionHolder converter = this.registerDefaultConverter(registry, contextBean.getBeanName());
        this.registerDefaultTemplate(registry, sessionBeanName, converter.getBeanName());
    }

    public String findSessionBeanName(BeanDefinitionRegistry registry, ListableBeanFactory factory) {
        BeanDefinitionHolder[] sessionFactoryBeans;
        int sessionFactoryCount;
        BeanDefinitionHolder[] sessionBeans = BeanDefinitionUtils.getBeanDefinitionsOfType(registry, factory, Session.class, true, false);
        int sessionCount = sessionBeans.length;
        int totalCount = sessionCount + (sessionFactoryCount = (sessionFactoryBeans = BeanDefinitionUtils.getBeanDefinitionsOfType(registry, factory, CassandraSessionFactoryBean.class, true, false)).length);
        if (totalCount == 0 || totalCount > 1) {
            throw this.createSessionException(totalCount, Session.class, CassandraSessionFactoryBean.class);
        }
        if (sessionCount == 1) {
            return sessionBeans[0].getBeanName();
        }
        return sessionFactoryBeans[0].getBeanName();
    }

    protected IllegalStateException createSessionException(int beanDefinitionCount, Class<?> ... types) {
        return new IllegalStateException(String.format("found %d beans of type%s [%s] - %s for creation of default [%s]", beanDefinitionCount, beanDefinitionCount == 1 ? "" : "s", StringUtils.arrayToCommaDelimitedString((Object[])types), beanDefinitionCount == 0 ? "need exactly one" : "can't disambiguate", CassandraTemplate.class.getName()));
    }

    protected BeanDefinitionHolder regsiterDefaultContext(BeanDefinitionRegistry registry) {
        BeanDefinitionHolder contextBean = new BeanDefinitionHolder((BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(BasicCassandraMappingContext.class).getBeanDefinition(), "cassandraMapping");
        registry.registerBeanDefinition(contextBean.getBeanName(), contextBean.getBeanDefinition());
        return contextBean;
    }

    public BeanDefinitionHolder registerDefaultConverter(BeanDefinitionRegistry registry, String contextBeanName) {
        BeanDefinitionBuilder converterBeanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(MappingCassandraConverter.class).addConstructorArgReference(contextBeanName);
        BeanDefinitionHolder beanDefinition = new BeanDefinitionHolder((BeanDefinition)converterBeanDefinitionBuilder.getBeanDefinition(), "cassandraConverter");
        registry.registerBeanDefinition(beanDefinition.getBeanName(), beanDefinition.getBeanDefinition());
        return beanDefinition;
    }

    public BeanDefinitionHolder registerDefaultTemplate(BeanDefinitionRegistry registry, String sessionBeanName, String converterBeanName) {
        BeanDefinitionBuilder templateBeanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(CassandraTemplate.class).addConstructorArgReference(sessionBeanName).addConstructorArgReference(converterBeanName);
        AbstractBeanDefinition beanDefinition = templateBeanDefinitionBuilder.getBeanDefinition();
        BeanDefinitionHolder template = new BeanDefinitionHolder((BeanDefinition)beanDefinition, "cqlTemplate");
        registry.registerBeanDefinition(template.getBeanName(), template.getBeanDefinition());
        return template;
    }
}

