/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.support;

import com.datastax.driver.core.querybuilder.Select;
import java.io.Serializable;
import java.util.List;
import org.springframework.cassandra.core.util.CollectionUtils;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.data.cassandra.core.CassandraTemplate;
import org.springframework.data.cassandra.repository.TypedIdCassandraRepository;
import org.springframework.data.cassandra.repository.query.CassandraEntityInformation;
import org.springframework.util.Assert;

public class SimpleCassandraRepository<T, ID extends Serializable>
implements TypedIdCassandraRepository<T, ID> {
    protected CassandraOperations template;
    protected CassandraEntityInformation<T, ID> entityInformation;

    public SimpleCassandraRepository(CassandraEntityInformation<T, ID> metadata, CassandraTemplate template) {
        Assert.notNull((Object)template);
        Assert.notNull(metadata);
        this.entityInformation = metadata;
        this.template = template;
    }

    public <S extends T> S save(S entity) {
        return this.template.insert(entity);
    }

    public <S extends T> List<S> save(Iterable<S> entities) {
        return this.template.insert(CollectionUtils.toList(entities));
    }

    public T findOne(ID id) {
        return this.template.selectOneById(this.entityInformation.getJavaType(), id);
    }

    public boolean exists(ID id) {
        return this.template.exists(this.entityInformation.getJavaType(), id);
    }

    public long count() {
        return this.template.count(this.entityInformation.getTableName());
    }

    public void delete(ID id) {
        this.template.deleteById(this.entityInformation.getJavaType(), id);
    }

    public void delete(T entity) {
        this.delete((T)this.entityInformation.getId(entity));
    }

    public void delete(Iterable<? extends T> entities) {
        this.template.delete(CollectionUtils.toList(entities));
    }

    public void deleteAll() {
        this.template.truncate(this.entityInformation.getTableName());
    }

    public List<T> findAll() {
        return this.template.selectAll(this.entityInformation.getJavaType());
    }

    public Iterable<T> findAll(Iterable<ID> ids) {
        return this.template.selectBySimpleIds(this.entityInformation.getJavaType(), ids);
    }

    protected List<T> findAll(Select query) {
        return this.template.select(query, this.entityInformation.getJavaType());
    }
}

