/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.jdbchdfs.common.support;

import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.jdbc.DataSourceBuilder;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.task.jdbchdfs.common.support.JdbcHdfsDataSourceProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.Environment;

@EnableConfigurationProperties(value={JdbcHdfsDataSourceProperties.class})
public class JdbcHdfsDataSourceConfiguration {
    @Autowired
    private JdbcHdfsDataSourceProperties props;
    @Autowired
    private Environment environment;

    @Bean(name={"taskDataSource"})
    @Primary
    public DataSource taskDataSource() {
        return this.getDefaultDataSource();
    }

    @Bean(name={"jdbchdfsDataSource"})
    public DataSource jdbcHdfsDataSource() {
        DataSource dataSource = this.props.getUrl() != null && this.props.getUsername() != null ? DataSourceBuilder.create().driverClassName(this.props.getDriverClassName()).url(this.props.getUrl()).username(this.props.getUsername()).password(this.props.getPassword()).build() : this.getDefaultDataSource();
        return dataSource;
    }

    private DataSource getDefaultDataSource() {
        return DataSourceBuilder.create().driverClassName(this.environment.getProperty("spring.datasource.driverClassName")).url(this.environment.getProperty("spring.datasource.url")).username(this.environment.getProperty("spring.datasource.username")).password(this.environment.getProperty("spring.datasource.password")).build();
    }
}

