/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.jdbchdfs.common;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.partition.support.Partitioner;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.StringUtils;

public class IncrementalColumnRangePartitioner
implements Partitioner,
StepExecutionListener,
InitializingBean {
    private static final Log log = LogFactory.getLog(IncrementalColumnRangePartitioner.class);
    public static final String BATCH_INCREMENTAL_MAX_ID = "batch.incremental.maxId";
    private JdbcOperations jdbcTemplate;
    private String table;
    private String column;
    private int partitions;
    private long partitionMax = Long.MAX_VALUE;
    private long partitionMin = Long.MIN_VALUE;
    private long incrementalMin = Long.MIN_VALUE;
    private JobExplorer jobExplorer;
    private String checkColumn;
    private Long overrideValue;

    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public void setPartitions(int partitions) {
        this.partitions = partitions;
    }

    public void setJobExplorer(JobExplorer jobExplorer) {
        this.jobExplorer = jobExplorer;
    }

    public void setCheckColumn(String checkColumn) {
        this.checkColumn = checkColumn;
    }

    public void setOverrideValue(Long overrideValue) {
        this.overrideValue = overrideValue;
    }

    public Map<String, ExecutionContext> partition(int gridSize) {
        StringBuilder incrementalClause = new StringBuilder();
        HashMap<String, ExecutionContext> result = new HashMap<String, ExecutionContext>();
        if (!StringUtils.hasText((String)this.checkColumn) && !StringUtils.hasText((String)this.column)) {
            ExecutionContext value = new ExecutionContext();
            value.put("partClause", (Object)"");
            result.put("partition0", value);
            value.put("partSuffix", (Object)"");
        } else {
            if (StringUtils.hasText((String)this.checkColumn)) {
                incrementalClause.append(this.checkColumn).append(" > ").append(this.incrementalMin);
            }
            long targetSize = (this.partitionMax - this.partitionMin) / (long)this.partitions + 1L;
            int number = 0;
            long start = this.partitionMin;
            long end = start + targetSize - 1L;
            while (start >= 0L && start <= this.partitionMax) {
                ExecutionContext value = new ExecutionContext();
                result.put("partition" + number, value);
                if (end >= this.partitionMax) {
                    end = this.partitionMax;
                }
                if (StringUtils.hasText((String)this.checkColumn)) {
                    value.putString("partClause", String.format("WHERE (%s BETWEEN %s AND %s) AND %s", this.column, start, end, incrementalClause.toString()));
                } else {
                    value.putString("partClause", String.format("WHERE (%s BETWEEN %s AND %s)", this.column, start, end));
                }
                value.putString("partSuffix", "-p" + number);
                start += targetSize;
                end += targetSize;
                ++number;
                log.debug((Object)("Current ExecutionContext = " + value));
            }
        }
        return result;
    }

    public void beforeStep(StepExecution stepExecution) {
        if (StringUtils.hasText((String)this.checkColumn)) {
            if (this.overrideValue != null && this.overrideValue >= 0L) {
                this.incrementalMin = this.overrideValue;
            } else {
                String jobName = stepExecution.getJobExecution().getJobInstance().getJobName();
                List jobInstances = this.jobExplorer.getJobInstances(jobName, 1, 1);
                if (jobInstances.size() > 0) {
                    JobInstance lastInstance = (JobInstance)jobInstances.get(jobInstances.size() - 1);
                    List executions = this.jobExplorer.getJobExecutions(lastInstance);
                    JobExecution lastExecution = (JobExecution)executions.get(0);
                    for (JobExecution execution : executions) {
                        if (lastExecution.getEndTime().getTime() >= execution.getEndTime().getTime()) continue;
                        lastExecution = execution;
                    }
                    this.incrementalMin = lastExecution.getExecutionContext().containsKey(BATCH_INCREMENTAL_MAX_ID) ? lastExecution.getExecutionContext().getLong(BATCH_INCREMENTAL_MAX_ID) : Long.MIN_VALUE;
                } else {
                    this.incrementalMin = Long.MIN_VALUE;
                }
            }
            long newMin = ((Integer)this.jdbcTemplate.queryForObject(String.format("select max(%s) from %s", this.checkColumn, this.table), Integer.class)).intValue();
            stepExecution.getExecutionContext().put(BATCH_INCREMENTAL_MAX_ID, (Object)newMin);
        }
        if (StringUtils.hasText((String)this.column) && StringUtils.hasText((String)this.table)) {
            Long maxResult;
            if (StringUtils.hasText((String)this.checkColumn)) {
                Long minResult = (Long)this.jdbcTemplate.queryForObject("SELECT MIN(" + this.column + ") from " + this.table + " where " + this.checkColumn + " > " + this.incrementalMin, Long.class);
                maxResult = (Long)this.jdbcTemplate.queryForObject("SELECT MAX(" + this.column + ") from " + this.table + " where " + this.checkColumn + " > " + this.incrementalMin, Long.class);
                this.partitionMin = minResult != null ? minResult : Long.MIN_VALUE;
                this.partitionMax = maxResult != null ? maxResult : Long.MAX_VALUE;
            } else {
                Long minResult = (Long)this.jdbcTemplate.queryForObject("SELECT MIN(" + this.column + ") from " + this.table, Long.class);
                maxResult = (Long)this.jdbcTemplate.queryForObject("SELECT MAX(" + this.column + ") from " + this.table, Long.class);
                this.partitionMin = minResult != null ? minResult : Long.MIN_VALUE;
                this.partitionMax = maxResult != null ? maxResult : Long.MAX_VALUE;
            }
        }
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        return stepExecution.getExitStatus();
    }

    public void afterPropertiesSet() throws Exception {
        if (!StringUtils.hasText((String)this.column)) {
            this.column = this.checkColumn;
        }
    }
}

