/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.jdbchdfs.common;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.WriteFailedException;
import org.springframework.batch.item.file.transform.LineAggregator;
import org.springframework.batch.item.support.AbstractItemStreamItemWriter;
import org.springframework.data.hadoop.store.DataStoreWriter;

public class HdfsTextItemWriter<T>
extends AbstractItemStreamItemWriter<T> {
    private static final String DEFAULT_LINE_SEPARATOR = System.getProperty("line.separator");
    private volatile String charset = "UTF-8";
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private volatile DataStoreWriter<byte[]> storeWriter;
    private LineAggregator<T> lineAggregator;
    private String lineSeparator = DEFAULT_LINE_SEPARATOR;

    public void write(List list) throws Exception {
        this.storeWriter.write((Object)this.getItemsAsByte(list));
    }

    public void update(ExecutionContext executionContext) {
        this.logger.debug("Flushing store writer");
        if (this.storeWriter != null) {
            try {
                this.storeWriter.flush();
            }
            catch (IOException e) {
                throw new IllegalStateException("Error while flushing store writer", e);
            }
        }
    }

    public void close() {
        this.logger.debug("Closing item writer");
        if (this.storeWriter != null) {
            try {
                this.storeWriter.flush();
                this.storeWriter.close();
            }
            catch (IOException e) {
                throw new IllegalStateException("Error while closing writer", e);
            }
            finally {
                this.storeWriter = null;
            }
        }
    }

    private byte[] getItemsAsByte(List<? extends T> items) {
        StringBuilder lines = new StringBuilder();
        for (T item : items) {
            lines.append(this.lineAggregator.aggregate(item) + this.lineSeparator);
        }
        try {
            return lines.toString().getBytes(this.charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new WriteFailedException("Could not write data.", (Throwable)e);
        }
    }

    public void setLineAggregator(LineAggregator<T> lineAggregator) {
        this.lineAggregator = lineAggregator;
    }

    public DataStoreWriter<byte[]> getStoreWriter() {
        return this.storeWriter;
    }

    public void setStoreWriter(DataStoreWriter<byte[]> storeWriter) {
        this.storeWriter = storeWriter;
    }
}

