/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.jdbchdfs.common;

import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.springframework.batch.item.file.transform.PassThroughLineAggregator;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cloud.task.jdbchdfs.common.HdfsTextItemWriter;
import org.springframework.cloud.task.jdbchdfs.common.JdbcHdfsTaskProperties;
import org.springframework.data.hadoop.store.DataStoreWriter;
import org.springframework.data.hadoop.store.output.OutputStreamWriter;
import org.springframework.data.hadoop.store.strategy.naming.ChainedFileNamingStrategy;
import org.springframework.data.hadoop.store.strategy.naming.FileNamingStrategy;
import org.springframework.data.hadoop.store.strategy.naming.RollingFileNamingStrategy;
import org.springframework.data.hadoop.store.strategy.naming.StaticFileNamingStrategy;
import org.springframework.data.hadoop.store.strategy.rollover.RolloverStrategy;
import org.springframework.data.hadoop.store.strategy.rollover.SizeRolloverStrategy;
import org.springframework.util.StringUtils;

public class HdfsTextItemWriterFactory
implements FactoryBean<HdfsTextItemWriter>,
InitializingBean {
    public static final String RM_MANAGER_PRINCIPAL = "rm-manager-principal";
    public static final String NAMENODE_PRINCIPAL = "namenode-principal";
    public static final String USER_PRINCIPAL = "user-principal";
    public static final String USER_KEYTAB = "user-keytab";
    public static final String SECURITY_METHOD = "security-method";
    public static final String PROPERTIES_LOCATION = "properties-location";
    public static final String REGISTER_URL_HANDLER = "register-url-handler";
    private HdfsTextItemWriter hdfsTextItemWriter;

    public HdfsTextItemWriterFactory(Configuration configuration, JdbcHdfsTaskProperties props, String partitionSuffix) throws Exception {
        ArrayList<Object> strategies = new ArrayList<Object>();
        strategies.add(new StaticFileNamingStrategy(props.getFileName() + partitionSuffix));
        strategies.add(new RollingFileNamingStrategy());
        strategies.add(new StaticFileNamingStrategy(props.getFileExtension(), "."));
        ChainedFileNamingStrategy fileNamingStrategy = new ChainedFileNamingStrategy();
        fileNamingStrategy.setStrategies(strategies);
        SizeRolloverStrategy rolloverStrategy = new SizeRolloverStrategy(props.getRollover());
        Path baseDirPath = new Path(props.getDirectory());
        this.setupConfiguration(configuration, props);
        OutputStreamWriter writer = new OutputStreamWriter(configuration, baseDirPath, null);
        writer.setInWritingSuffix(".tmp");
        writer.setFileNamingStrategy((FileNamingStrategy)fileNamingStrategy);
        writer.setRolloverStrategy((RolloverStrategy)rolloverStrategy);
        this.hdfsTextItemWriter = new HdfsTextItemWriter();
        this.hdfsTextItemWriter.setLineAggregator(new PassThroughLineAggregator());
        this.hdfsTextItemWriter.setStoreWriter((DataStoreWriter<byte[]>)writer);
        if (writer instanceof InitializingBean) {
            writer.afterPropertiesSet();
        }
    }

    private void setupConfiguration(Configuration configuration, JdbcHdfsTaskProperties props) {
        if (StringUtils.hasText((String)props.getFsUri())) {
            configuration.set("fs.defaultFS", props.getFsUri());
        }
        if (StringUtils.hasText((String)props.getRmManagerPrincipal())) {
            configuration.set(RM_MANAGER_PRINCIPAL, props.getRmManagerPrincipal());
        }
        if (StringUtils.hasText((String)props.getNameNodePrincipal())) {
            configuration.set(NAMENODE_PRINCIPAL, props.getNameNodePrincipal());
        }
        if (StringUtils.hasText((String)props.getUserPrincipal())) {
            configuration.set(USER_PRINCIPAL, props.getUserPrincipal());
        }
        if (StringUtils.hasText((String)props.getUserKeyTab())) {
            configuration.set(USER_KEYTAB, props.getUserKeyTab());
        }
        if (StringUtils.hasText((String)props.getSecurityMethod())) {
            configuration.set(SECURITY_METHOD, props.getSecurityMethod());
        }
        if (StringUtils.hasText((String)props.getPropertiesLocation())) {
            configuration.set(PROPERTIES_LOCATION, props.getPropertiesLocation());
        }
        if (StringUtils.hasText((String)props.getRegisterUrlHandler())) {
            configuration.set(REGISTER_URL_HANDLER, props.getRegisterUrlHandler());
        }
    }

    public HdfsTextItemWriter getObject() throws Exception {
        return this.hdfsTextItemWriter;
    }

    public Class<?> getObjectType() {
        return HdfsTextItemWriter.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
    }
}

