/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.app.timestamp.batch;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.configuration.annotation.EnableBatchProcessing;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.task.app.timestamp.batch.TimestampBatchTaskProperties;
import org.springframework.cloud.task.configuration.EnableTask;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@EnableTask
@EnableBatchProcessing
@Configuration
@EnableConfigurationProperties(value={TimestampBatchTaskProperties.class})
public class TimestampBatchTaskConfiguration {
    private static final Log logger = LogFactory.getLog(TimestampBatchTaskProperties.class);
    @Autowired
    public JobBuilderFactory jobBuilderFactory;
    @Autowired
    public StepBuilderFactory stepBuilderFactory;
    @Autowired
    private TimestampBatchTaskProperties config;

    @Bean
    public Job job1() {
        return this.jobBuilderFactory.get("job1").start((Step)this.stepBuilderFactory.get("job1step1").tasklet(new Tasklet(){

            public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
                SimpleDateFormat dateFormat = new SimpleDateFormat(TimestampBatchTaskConfiguration.this.config.getFormat());
                logger.info((Object)String.format("Job1 was run with date %s", dateFormat.format(new Date())));
                return RepeatStatus.FINISHED;
            }
        }).build()).build();
    }

    @Bean
    public Job job2() {
        return this.jobBuilderFactory.get("job2").start((Step)this.stepBuilderFactory.get("job2step1").tasklet(new Tasklet(){

            public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
                SimpleDateFormat dateFormat = new SimpleDateFormat(TimestampBatchTaskConfiguration.this.config.getFormat());
                logger.info((Object)String.format("Job2 was run with date %s", dateFormat.format(new Date())));
                return RepeatStatus.FINISHED;
            }
        }).build()).build();
    }
}

