/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.app.sqoop.tool;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sqoop.Sqoop;
import org.apache.sqoop.util.Jars;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.task.app.sqoop.tool.SqoopToolTaskProperties;
import org.springframework.cloud.task.configuration.EnableTask;
import org.springframework.cloud.task.sqoop.common.SqoopCommonRunnerUtils;
import org.springframework.cloud.task.sqoop.common.SqoopCommonTaskProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@EnableTask
@Configuration
@EnableConfigurationProperties(value={SqoopToolTaskProperties.class})
public class SqoopToolTaskConfiguration {
    @Bean
    public CommandLineRunner commandLineRunner() {
        return new SqoopToolRunner();
    }

    private class SqoopToolRunner
    implements CommandLineRunner {
        private final Log logger = LogFactory.getLog(SqoopToolRunner.class);
        @Autowired
        private SqoopToolTaskProperties props;
        @Autowired
        private org.apache.hadoop.conf.Configuration hadoopConfiguration;
        @Value(value="${spring.hadoop.config.mapreduce.framework.name:yarn}")
        private String mapreduceFramework;

        private SqoopToolRunner() {
        }

        public void run(String ... args) throws Exception {
            List<String> finalArguments = this.createFinalArguments();
            this.logger.info((Object)("Running Sqoop tool with arguments: " + finalArguments));
            org.apache.hadoop.conf.Configuration configuration = new org.apache.hadoop.conf.Configuration(this.hadoopConfiguration);
            this.logger.info((Object)("Setting mapreduce.framework.name to " + this.mapreduceFramework));
            configuration.set("mapreduce.framework.name", this.mapreduceFramework);
            int ret = Sqoop.runTool((String[])finalArguments.toArray(new String[finalArguments.size()]), (org.apache.hadoop.conf.Configuration)configuration);
            this.logger.info((Object)("Sqoop tool completed with return code: " + ret));
            if (ret != 0) {
                throw new RuntimeException("Sqoop job failed - return code " + ret);
            }
        }

        protected List<String> createFinalArguments() {
            ArrayList<String> finalArguments = new ArrayList<String>();
            String command = this.props.getCommand();
            finalArguments.add(command);
            SqoopCommonRunnerUtils.setConnectProperties((SqoopCommonTaskProperties)this.props, finalArguments);
            if (command.toLowerCase().startsWith("import") || command.toLowerCase().startsWith("export")) {
                finalArguments.add("--hadoop-mapred-home=" + Jars.getJarPathForClass(Jars.class).substring(0, Jars.getJarPathForClass(Jars.class).lastIndexOf("/")));
            }
            ArrayList<String> toolArguments = new ArrayList<String>();
            if (StringUtils.hasText((String)this.props.getToolArgs())) {
                String[] args;
                for (String arg : args = this.props.getToolArgs().split("\\s+")) {
                    if (arg.startsWith("--hive") || arg.startsWith("--hcatalog") || arg.startsWith("--hbase") || arg.startsWith("--accumulo")) {
                        throw new IllegalArgumentException(arg + " is incompatible with tool execution from a distributed task.");
                    }
                    toolArguments.add(arg);
                }
            }
            finalArguments.addAll(toolArguments);
            return finalArguments;
        }
    }
}

