/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.app.sqoop.job;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sqoop.Sqoop;
import org.apache.sqoop.util.Jars;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.task.app.sqoop.job.SqoopJobTaskProperties;
import org.springframework.cloud.task.configuration.EnableTask;
import org.springframework.cloud.task.sqoop.common.SqoopCommonRunnerUtils;
import org.springframework.cloud.task.sqoop.common.SqoopCommonTaskProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@EnableTask
@Configuration
@EnableConfigurationProperties(value={SqoopJobTaskProperties.class})
public class SqoopJobTaskConfiguration {
    @Bean
    public CommandLineRunner commandLineRunner() {
        return new SqoopJobRunner();
    }

    private class SqoopJobRunner
    implements CommandLineRunner {
        private final Log logger = LogFactory.getLog(SqoopJobRunner.class);
        private SqoopJobTaskProperties props;
        @Autowired
        private org.apache.hadoop.conf.Configuration hadoopConfiguration;
        @Value(value="${spring.hadoop.config.mapreduce.framework.name:yarn}")
        private String mapreduceFramework;

        private SqoopJobRunner() {
        }

        public void run(String ... args) throws Exception {
            List<String> finalJobArguments = this.createFinalJobArguments();
            this.logger.info((Object)("Running Sqoop job with arguments: " + finalJobArguments));
            org.apache.hadoop.conf.Configuration configuration = new org.apache.hadoop.conf.Configuration(this.hadoopConfiguration);
            this.logger.info((Object)("Setting mapreduce.framework.name to " + this.mapreduceFramework));
            configuration.set("mapreduce.framework.name", this.mapreduceFramework);
            configuration.set("sqoop.metastore.client.autoconnect.url", this.props.getMetastoreUrl());
            if (StringUtils.hasText((String)this.props.getMetastoreUsername())) {
                configuration.set("sqoop.metastore.client.autoconnect.username", this.props.getMetastoreUsername());
            }
            if (StringUtils.hasText((String)this.props.getMetastorePassword())) {
                configuration.set("sqoop.metastore.client.autoconnect.password", this.props.getMetastorePassword());
            }
            int ret = Sqoop.runTool((String[])finalJobArguments.toArray(new String[finalJobArguments.size()]), (org.apache.hadoop.conf.Configuration)configuration);
            this.logger.info((Object)("Sqoop job completed with return code: " + ret));
            if (ret != 0) {
                throw new RuntimeException("Sqoop job failed - return code " + ret);
            }
        }

        public SqoopJobTaskProperties getProps() {
            return this.props;
        }

        @Autowired
        public void setProps(SqoopJobTaskProperties props) {
            this.props = props;
        }

        protected List<String> createFinalJobArguments() {
            ArrayList<String> finalArguments = new ArrayList<String>();
            finalArguments.add("job");
            String action = this.props.getAction();
            finalArguments.add("--" + action);
            finalArguments.add(this.props.getJobName());
            finalArguments.add("--");
            String command = this.props.getCommand();
            if (action.toLowerCase().startsWith("create")) {
                finalArguments.add(command);
            }
            if (action.toLowerCase().startsWith("exec")) {
                finalArguments.add("--hadoop-mapred-home");
                finalArguments.add(Jars.getJarPathForClass(Jars.class).substring(0, Jars.getJarPathForClass(Jars.class).lastIndexOf("/")));
            }
            SqoopCommonRunnerUtils.setConnectProperties((SqoopCommonTaskProperties)this.props, finalArguments);
            ArrayList<String> toolArguments = new ArrayList<String>();
            if (StringUtils.hasText((String)this.props.getToolArgs())) {
                String[] args;
                for (String arg : args = this.props.getToolArgs().split("\\s+")) {
                    if (arg.startsWith("--hive") || arg.startsWith("--hcatalog") || arg.startsWith("--hbase") || arg.startsWith("--accumulo")) {
                        throw new IllegalArgumentException(arg + " is incompatible with job execution from a distributed task.");
                    }
                    toolArguments.add(arg);
                }
            }
            finalArguments.addAll(toolArguments);
            return finalArguments;
        }
    }
}

