/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.app.spark.cluster;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.deploy.master.DriverState;
import org.apache.spark.deploy.rest.CreateSubmissionRequest;
import org.apache.spark.deploy.rest.RestSubmissionClient;
import org.apache.spark.deploy.rest.SubmitRestProtocolResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.task.app.spark.cluster.SparkClusterTaskProperties;
import org.springframework.cloud.task.configuration.EnableTask;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Map;

@EnableTask
@Configuration
@EnableConfigurationProperties(value={SparkClusterTaskProperties.class})
public class SparkClusterTaskConfiguration {
    @Bean
    public CommandLineRunner commandLineRunner() {
        return new SparkAppClusterRunner();
    }

    private class SparkAppClusterRunner
    implements CommandLineRunner {
        private final Log logger = LogFactory.getLog(SparkAppClusterRunner.class);
        @Autowired
        private SparkClusterTaskProperties config;

        private SparkAppClusterRunner() {
        }

        public void run(String ... args) throws Exception {
            SubmitRestProtocolResponse stat;
            String appState;
            RestSubmissionClient rsc = new RestSubmissionClient(this.config.getRestUrl());
            HashMap<String, String> sparkProps = new HashMap<String, String>();
            sparkProps.put("spark.app.name", this.config.getAppName());
            sparkProps.put("spark.master", this.config.getMaster());
            if (StringUtils.hasText((String)this.config.getExecutorMemory())) {
                sparkProps.put("spark.executor.memory", this.config.getExecutorMemory());
            }
            if (StringUtils.hasText((String)this.config.getResourceArchives())) {
                sparkProps.put("spark.jars", this.config.getAppJar().trim() + "," + this.config.getResourceArchives().trim());
            } else {
                sparkProps.put("spark.jars", this.config.getAppJar());
            }
            if (StringUtils.hasText((String)this.config.getResourceFiles())) {
                sparkProps.put("spark.files", this.config.getResourceFiles());
            }
            Map envMap = ((scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(new HashMap()).asScala()).toMap(Predef$.MODULE$.conforms());
            Map propsMap = ((scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(sparkProps).asScala()).toMap(Predef$.MODULE$.conforms());
            CreateSubmissionRequest csr = rsc.constructSubmitRequest(this.config.getAppJar(), this.config.getAppClass(), this.config.getAppArgs(), propsMap, envMap);
            SubmitRestProtocolResponse resp = rsc.createSubmission(csr);
            String submissionId = this.getJsonProperty(resp.toJson(), "submissionId");
            this.logger.info((Object)("Submitted Spark App with submissionId: " + submissionId));
            do {
                Thread.sleep(this.config.getAppStatusPollInterval());
            } while ((appState = this.getJsonProperty((stat = rsc.requestSubmissionStatus(submissionId, false)).toJson(), "driverState")).equals(DriverState.SUBMITTED().toString()) || appState.equals(DriverState.RUNNING().toString()) || appState.equals(DriverState.RELAUNCHING().toString()) || appState.equals(DriverState.UNKNOWN().toString()));
            System.out.println("Spark App completed with status: " + appState);
            if (!appState.equals(DriverState.FINISHED().toString())) {
                throw new RuntimeException("Spark App submission " + submissionId + " failed with status " + appState);
            }
        }

        private String getJsonProperty(String json, String prop) {
            try {
                HashMap props = (HashMap)new ObjectMapper().readValue(json, HashMap.class);
                return props.get(prop).toString();
            }
            catch (IOException ioe) {
                return null;
            }
        }
    }
}

