/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.app.spark.client;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.deploy.SparkSubmit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.task.app.spark.client.SparkClientTaskProperties;
import org.springframework.cloud.task.configuration.EnableTask;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@EnableTask
@Configuration
@EnableConfigurationProperties(value={SparkClientTaskProperties.class})
public class SparkClientTaskConfiguration {
    @Bean
    public CommandLineRunner commandLineRunner() {
        return new SparkAppClientRunner();
    }

    private class SparkAppClientRunner
    implements CommandLineRunner {
        private final Log logger = LogFactory.getLog(SparkAppClientRunner.class);
        @Autowired
        private SparkClientTaskProperties config;

        private SparkAppClientRunner() {
        }

        public void run(String ... args) throws Exception {
            ArrayList<String> argList = new ArrayList<String>();
            if (StringUtils.hasText((String)this.config.getAppName())) {
                argList.add("--name");
                argList.add(this.config.getAppName());
            }
            argList.add("--class");
            argList.add(this.config.getAppClass());
            argList.add("--master");
            argList.add(this.config.getMaster());
            argList.add("--deploy-mode");
            argList.add("client");
            argList.add(this.config.getAppJar());
            if (StringUtils.hasText((String)this.config.getResourceFiles())) {
                argList.add("--files");
                argList.add(this.config.getResourceFiles());
            }
            if (StringUtils.hasText((String)this.config.getResourceArchives())) {
                argList.add("--jars");
                argList.add(this.config.getResourceArchives());
            }
            argList.addAll(Arrays.asList(this.config.getAppArgs()));
            try {
                SparkSubmit.main((String[])argList.toArray(new String[argList.size()]));
            }
            catch (Throwable t) {
                this.logger.error((Object)("Spark Application failed: " + t.getMessage()), t);
                throw new RuntimeException("Spark Application failed", t);
            }
        }
    }
}

