/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.app.spark.client;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.deploy.SparkSubmit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.task.app.spark.client.SparkClientTaskProperties;
import org.springframework.cloud.task.configuration.EnableTask;
import org.springframework.cloud.task.sparkapp.common.SparkAppCommonTaskProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@EnableTask
@Configuration
@EnableConfigurationProperties(value={SparkClientTaskProperties.class, SparkAppCommonTaskProperties.class})
public class SparkClientTaskConfiguration {
    @Bean
    public CommandLineRunner commandLineRunner() {
        return new SparkAppClientRunner();
    }

    private class SparkAppClientRunner
    implements CommandLineRunner {
        private final Log logger = LogFactory.getLog(SparkAppClientRunner.class);
        @Autowired
        private SparkClientTaskProperties config;
        @Autowired
        private SparkAppCommonTaskProperties commonConfig;

        private SparkAppClientRunner() {
        }

        public void run(String ... args) throws Exception {
            ArrayList<String> argList = new ArrayList<String>();
            if (StringUtils.hasText((String)this.commonConfig.getAppName())) {
                argList.add("--name");
                argList.add(this.commonConfig.getAppName());
            }
            argList.add("--class");
            argList.add(this.commonConfig.getAppClass());
            argList.add("--master");
            argList.add(this.config.getMaster());
            argList.add("--deploy-mode");
            argList.add("client");
            argList.add(this.commonConfig.getAppJar());
            if (StringUtils.hasText((String)this.commonConfig.getResourceFiles())) {
                argList.add("--files");
                argList.add(this.commonConfig.getResourceFiles());
            }
            if (StringUtils.hasText((String)this.commonConfig.getResourceArchives())) {
                argList.add("--jars");
                argList.add(this.commonConfig.getResourceArchives());
            }
            argList.addAll(Arrays.asList(this.commonConfig.getAppArgs()));
            try {
                SparkSubmit.main((String[])argList.toArray(new String[argList.size()]));
            }
            catch (Throwable t) {
                this.logger.error((Object)("Spark Application failed: " + t.getMessage()), t);
                throw new RuntimeException("Spark Application failed", t);
            }
        }
    }
}

