/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.triggertask.source;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.app.annotation.PollableSource;
import org.springframework.cloud.stream.app.trigger.TriggerConfiguration;
import org.springframework.cloud.stream.app.trigger.TriggerPropertiesMaxMessagesDefaultOne;
import org.springframework.cloud.stream.app.triggertask.source.TaskPayloadProperties;
import org.springframework.cloud.stream.app.triggertask.source.arguments.CommandLineArgumentTransformer;
import org.springframework.cloud.stream.app.triggertask.source.arguments.PassThroughCommandLineArgumentTransformer;
import org.springframework.cloud.stream.messaging.Source;
import org.springframework.cloud.task.launcher.TaskLaunchRequest;
import org.springframework.context.annotation.Import;
import org.springframework.util.StringUtils;

@EnableBinding(value={Source.class})
@EnableConfigurationProperties(value={TaskPayloadProperties.class, TriggerPropertiesMaxMessagesDefaultOne.class})
@Import(value={TriggerConfiguration.class})
public class TriggertaskSourceConfiguration {
    private static final Pattern PROPERTIES_PATTERN = Pattern.compile("(,\\s*[^=]+=)|(,[^=]+=)");
    private static final Pattern DEPLOYMENT_PARAMS_PATTERN = Pattern.compile("(\\s(?=([^\\\"']*[\\\"'][^\\\"']*[\\\"'])*[^\\\"']*$))");
    @Autowired
    private TaskPayloadProperties taskPayloadProperties;
    private CommandLineArgumentTransformer commandLineArgumentTransformer = new PassThroughCommandLineArgumentTransformer();

    @PollableSource
    public Object triggerTaskSource() {
        return new TaskLaunchRequest(this.taskPayloadProperties.getUri(), TriggertaskSourceConfiguration.parseParams(this.commandLineArgumentTransformer.transform(this.taskPayloadProperties.getCommandLineArgs())), TriggertaskSourceConfiguration.parseProperties(this.taskPayloadProperties.getEnvironmentProperties()), TriggertaskSourceConfiguration.parseProperties(this.taskPayloadProperties.getDeploymentProperties()), this.taskPayloadProperties.getApplicationName());
    }

    public void setCommandLineArgumentTransformer(CommandLineArgumentTransformer commandLineArgumentTransformer) {
        this.commandLineArgumentTransformer = commandLineArgumentTransformer;
    }

    public static Map<String, String> parseProperties(String s) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (!StringUtils.isEmpty((Object)s)) {
            Matcher matcher = PROPERTIES_PATTERN.matcher(s);
            int start = 0;
            while (matcher.find()) {
                TriggertaskSourceConfiguration.addKeyValuePairAsProperty(s.substring(start, matcher.start()), properties);
                start = matcher.start() + 1;
            }
            TriggertaskSourceConfiguration.addKeyValuePairAsProperty(s.substring(start), properties);
        }
        return properties;
    }

    private static void addKeyValuePairAsProperty(String pair, Map<String, String> properties) {
        int firstEquals = pair.indexOf(61);
        if (firstEquals != -1) {
            properties.put(pair.substring(0, firstEquals).trim(), pair.substring(firstEquals + 1).trim());
        }
    }

    private static List<String> parseParams(String param) {
        String p;
        ArrayList<String> paramsToUse = new ArrayList<String>();
        Matcher regexMatcher = DEPLOYMENT_PARAMS_PATTERN.matcher(param);
        int start = 0;
        while (regexMatcher.find()) {
            p = TriggertaskSourceConfiguration.removeQuoting(param.substring(start, regexMatcher.start()).trim());
            if (StringUtils.hasText((String)p)) {
                paramsToUse.add(p);
            }
            start = regexMatcher.start();
        }
        if (param != null && param.length() > 0 && StringUtils.hasText((String)(p = TriggertaskSourceConfiguration.removeQuoting(param.substring(start, param.length()).trim())))) {
            paramsToUse.add(p);
        }
        return paramsToUse;
    }

    private static String removeQuoting(String param) {
        String[] split;
        param = TriggertaskSourceConfiguration.removeQuote(param, '\'');
        if (StringUtils.hasText((String)(param = TriggertaskSourceConfiguration.removeQuote(param, '\"'))) && (split = param.split("=", 2)).length == 2) {
            String value = TriggertaskSourceConfiguration.removeQuote(split[1], '\'');
            value = TriggertaskSourceConfiguration.removeQuote(value, '\"');
            param = split[0] + "=" + value;
        }
        return param;
    }

    private static String removeQuote(String param, char c) {
        if (param != null && param.length() > 1 && param.charAt(0) == c && param.charAt(param.length() - 1) == c) {
            param = param.substring(1, param.length() - 1);
        }
        return param;
    }
}

