/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.tcp.client.source;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.app.tcp.EncoderDecoderFactoryBean;
import org.springframework.cloud.stream.app.tcp.client.source.TcpClientSourceProperties;
import org.springframework.cloud.stream.messaging.Source;
import org.springframework.context.annotation.Bean;
import org.springframework.core.serializer.Deserializer;
import org.springframework.integration.ip.config.TcpConnectionFactoryFactoryBean;
import org.springframework.integration.ip.tcp.TcpReceivingChannelAdapter;
import org.springframework.integration.ip.tcp.connection.AbstractConnectionFactory;
import org.springframework.integration.ip.tcp.connection.TcpMessageMapper;
import org.springframework.integration.ip.tcp.serializer.AbstractByteArraySerializer;

@EnableBinding(value={Source.class})
@EnableConfigurationProperties(value={TcpClientSourceProperties.class})
public class TcpClientSourceConfiguration {
    @Autowired
    private TcpClientSourceProperties properties;

    @Bean
    public TcpReceivingChannelAdapter adapter(@Qualifier(value="tcpClientConnectionFactory") AbstractConnectionFactory connectionFactory) {
        TcpReceivingChannelAdapter adapter = new TcpReceivingChannelAdapter();
        adapter.setConnectionFactory(connectionFactory);
        adapter.setClientMode(true);
        adapter.setRetryInterval(this.properties.getRetryInterval());
        adapter.setOutputChannelName("output");
        return adapter;
    }

    @Bean
    public TcpConnectionFactoryFactoryBean tcpClientConnectionFactory(@Qualifier(value="tcpClientMapper") TcpMessageMapper mapper, @Qualifier(value="tcpClientDecoder") AbstractByteArraySerializer decoder) throws Exception {
        TcpConnectionFactoryFactoryBean factoryBean = new TcpConnectionFactoryFactoryBean();
        factoryBean.setType("client");
        factoryBean.setHost(this.properties.getHost());
        factoryBean.setPort(this.properties.getPort());
        factoryBean.setUsingNio(this.properties.isNio());
        factoryBean.setUsingDirectBuffers(this.properties.isUseDirectBuffers());
        factoryBean.setLookupHost(this.properties.isReverseLookup());
        factoryBean.setDeserializer((Deserializer)decoder);
        factoryBean.setSoTimeout(this.properties.getSocketTimeout());
        factoryBean.setMapper(mapper);
        return factoryBean;
    }

    @Bean
    public TcpMessageMapper tcpClientMapper() {
        TcpMessageMapper mapper = new TcpMessageMapper();
        mapper.setCharset(this.properties.getCharset());
        return mapper;
    }

    @Bean
    public EncoderDecoderFactoryBean tcpClientDecoder() {
        EncoderDecoderFactoryBean factoryBean = new EncoderDecoderFactoryBean(this.properties.getDecoder());
        factoryBean.setMaxMessageSize(this.properties.getBufferSize());
        return factoryBean;
    }
}

