/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.syslog.source;

import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotNull;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="syslog")
public class SyslogSourceProperties {
    private int bufferSize = 2048;
    private String protocol = "tcp";
    private int port = 1514;
    private boolean nio = false;
    private boolean reverseLookup;
    private int socketTimeout;
    private String rfc = "3164";

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isNio() {
        return this.nio;
    }

    public void setNio(boolean nio) {
        this.nio = nio;
    }

    public boolean isReverseLookup() {
        return this.reverseLookup;
    }

    public void setReverseLookup(boolean reverseLookup) {
        this.reverseLookup = reverseLookup;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    @NotNull
    public String getRfc() {
        return this.rfc;
    }

    public void setRfc(String rfc) {
        this.rfc = rfc;
    }

    @AssertTrue(message="rfc must be 5424 or 3164")
    public boolean isSupportedRfc() {
        return "5424".equals(this.rfc) || "3164".equals(this.rfc);
    }

    @AssertTrue(message="protocl must be 'udp' or 'tcp' or 'both'")
    public boolean isSupportedProtocol() {
        return "tcp".equals(this.protocol) || "udp".equals(this.protocol) || "both".equals(this.protocol);
    }
}

