/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.syslog.source;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.app.syslog.source.SyslogSourceProperties;
import org.springframework.cloud.stream.messaging.Source;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.serializer.Deserializer;
import org.springframework.integration.ip.tcp.connection.AbstractServerConnectionFactory;
import org.springframework.integration.ip.tcp.connection.TcpNetServerConnectionFactory;
import org.springframework.integration.ip.tcp.connection.TcpNioServerConnectionFactory;
import org.springframework.integration.ip.tcp.serializer.ByteArrayLfSerializer;
import org.springframework.integration.syslog.DefaultMessageConverter;
import org.springframework.integration.syslog.MessageConverter;
import org.springframework.integration.syslog.RFC5424MessageConverter;
import org.springframework.integration.syslog.inbound.RFC6587SyslogDeserializer;
import org.springframework.integration.syslog.inbound.SyslogReceivingChannelAdapterSupport;
import org.springframework.integration.syslog.inbound.TcpSyslogReceivingChannelAdapter;
import org.springframework.integration.syslog.inbound.UdpSyslogReceivingChannelAdapter;

@EnableBinding(value={Source.class})
@EnableConfigurationProperties(value={SyslogSourceProperties.class})
public class SyslogSourceConfiguration {
    @Autowired
    private Source channels;
    @Autowired
    private SyslogSourceProperties properties;

    @Bean
    @ConditionalOnProperty(name={"syslog.protocol"}, havingValue="udp")
    public UdpSyslogReceivingChannelAdapter udpAdapter() {
        return this.createUdpAdapter();
    }

    @Bean
    @ConditionalOnProperty(name={"syslog.protocol"}, havingValue="both")
    public UdpSyslogReceivingChannelAdapter udpBothAdapter() {
        System.out.println("WOOOOT");
        return this.createUdpAdapter();
    }

    private UdpSyslogReceivingChannelAdapter createUdpAdapter() {
        UdpSyslogReceivingChannelAdapter adapter = new UdpSyslogReceivingChannelAdapter();
        this.setAdapterProperties((SyslogReceivingChannelAdapterSupport)adapter);
        return adapter;
    }

    @Bean
    @ConditionalOnProperty(name={"syslog.protocol"}, havingValue="tcp", matchIfMissing=true)
    public TcpSyslogReceivingChannelAdapter tcpAdapter(@Qualifier(value="syslogSourceConnectionFactory") AbstractServerConnectionFactory connectionFactory) {
        return this.createTcpAdapter(connectionFactory);
    }

    @Bean
    @ConditionalOnProperty(name={"syslog.protocol"}, havingValue="both")
    public TcpSyslogReceivingChannelAdapter tcpBothAdapter(@Qualifier(value="syslogSourceConnectionFactory") AbstractServerConnectionFactory connectionFactory) {
        return this.createTcpAdapter(connectionFactory);
    }

    private TcpSyslogReceivingChannelAdapter createTcpAdapter(AbstractServerConnectionFactory connectionFactory) {
        TcpSyslogReceivingChannelAdapter adapter = new TcpSyslogReceivingChannelAdapter();
        adapter.setConnectionFactory(connectionFactory);
        this.setAdapterProperties((SyslogReceivingChannelAdapterSupport)adapter);
        return adapter;
    }

    private void setAdapterProperties(SyslogReceivingChannelAdapterSupport adapter) {
        adapter.setPort(this.properties.getPort());
        adapter.setConverter(this.syslogConverter());
        adapter.setOutputChannel(this.channels.output());
    }

    @Bean
    public MessageConverter syslogConverter() {
        if (this.properties.getRfc().equals("5424")) {
            return new RFC5424MessageConverter();
        }
        return new DefaultMessageConverter();
    }

    @Configuration
    @ConditionalOnProperty(name={"syslog.protocol"}, havingValue="both")
    protected static class BothBits
    extends TcpBits {
        protected BothBits() {
        }
    }

    @Configuration
    @ConditionalOnProperty(name={"syslog.protocol"}, havingValue="tcp", matchIfMissing=true)
    protected static class TcpBits {
        @Autowired
        private SyslogSourceProperties properties;

        protected TcpBits() {
        }

        @Bean
        public AbstractServerConnectionFactory syslogSourceConnectionFactory(@Qualifier(value="syslogSourceDecoder") Deserializer<?> decoder) throws Exception {
            Object factory = this.properties.isNio() ? new TcpNioServerConnectionFactory(this.properties.getPort()) : new TcpNetServerConnectionFactory(this.properties.getPort());
            factory.setLookupHost(this.properties.isReverseLookup());
            factory.setDeserializer(decoder);
            factory.setSoTimeout(this.properties.getSocketTimeout());
            return factory;
        }

        @Bean
        public Deserializer<?> syslogSourceDecoder() {
            ByteArrayLfSerializer decoder = new ByteArrayLfSerializer();
            decoder.setMaxMessageSize(this.properties.getBufferSize());
            if (this.properties.getRfc().equals("5424")) {
                return new RFC6587SyslogDeserializer((Deserializer)decoder);
            }
            return decoder;
        }
    }
}

