/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.sftp.source.tasklauncher;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.app.sftp.common.source.SftpSourceProperties;
import org.springframework.cloud.stream.app.sftp.source.metadata.SftpSourceIdempotentReceiverConfiguration;
import org.springframework.cloud.stream.app.sftp.source.task.SftpSourceTaskProperties;
import org.springframework.cloud.task.launcher.TaskLaunchRequest;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.integration.annotation.IdempotentReceiver;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.integration.handler.MessageProcessor;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.StringUtils;

@EnableConfigurationProperties(value={SftpSourceProperties.class, SftpSourceTaskProperties.class})
@Import(value={SftpSourceIdempotentReceiverConfiguration.class})
public class SftpSourceTaskLauncherConfiguration {
    public static final String SFTP_HOST_PROPERTY_KEY = "sftp_host";
    public static final String SFTP_PORT_PROPERTY_KEY = "sftp_port";
    public static final String SFTP_USERNAME_PROPERTY_KEY = "sftp_username";
    public static final String SFTP_PASSWORD_PROPERTY_KEY = "sftp_password";
    public static final String SFTP_SELECTED_SERVER_PROPERTY_KEY = "sftp_selectedServer";
    protected static final String DATASOURCE_URL_PROPERTY_KEY = "spring.datasource.url";
    protected static final String DATASOURCE_USERNAME_PROPERTY_KEY = "spring.datasource.username";
    protected static final String DATASOURCE_PASSWORD_PROPERTY_KEY = "spring.datasource.password";
    private final SftpSourceProperties sftpSourceProperties;
    private final SftpSourceTaskProperties sftpSourceTaskProperties;

    @Autowired
    public SftpSourceTaskLauncherConfiguration(SftpSourceProperties sftpSourceProperties, SftpSourceTaskProperties sftpSourceTaskProperties) {
        this.sftpSourceProperties = sftpSourceProperties;
        this.sftpSourceTaskProperties = sftpSourceTaskProperties;
    }

    @Bean
    @ConditionalOnProperty(name={"sftp.task-launcher-output"}, havingValue="true")
    @IdempotentReceiver(value={"idempotentReceiverInterceptor"})
    @ServiceActivator(inputChannel="sftpFileTaskLaunchChannel", outputChannel="output")
    public MessageProcessor<Message<?>> standaloneTaskLaunchRequestTransformer() {
        return message -> {
            TaskLaunchRequest outboundPayload = new TaskLaunchRequest(this.sftpSourceTaskProperties.getResourceUri(), this.getCommandLineArgs(message), this.getEnvironmentProperties(), this.getDeploymentProperties(), null);
            MessageBuilder builder = MessageBuilder.withPayload((Object)outboundPayload).copyHeaders((Map)message.getHeaders()).setHeader("contentType", (Object)MimeTypeUtils.APPLICATION_JSON);
            if (this.sftpSourceProperties.isMultiSource()) {
                outboundPayload.getEnvironmentProperties().put(SFTP_HOST_PROPERTY_KEY, (String)message.getHeaders().get((Object)SFTP_HOST_PROPERTY_KEY));
                outboundPayload.getEnvironmentProperties().put(SFTP_PORT_PROPERTY_KEY, String.valueOf(message.getHeaders().get((Object)SFTP_PORT_PROPERTY_KEY)));
                outboundPayload.getEnvironmentProperties().put(SFTP_USERNAME_PROPERTY_KEY, (String)message.getHeaders().get((Object)SFTP_USERNAME_PROPERTY_KEY));
                outboundPayload.getEnvironmentProperties().put(SFTP_PASSWORD_PROPERTY_KEY, (String)message.getHeaders().get((Object)SFTP_PASSWORD_PROPERTY_KEY));
                outboundPayload.getEnvironmentProperties().put(SFTP_SELECTED_SERVER_PROPERTY_KEY, (String)message.getHeaders().get((Object)SFTP_SELECTED_SERVER_PROPERTY_KEY));
                builder.removeHeaders(new String[]{SFTP_HOST_PROPERTY_KEY, SFTP_PORT_PROPERTY_KEY, SFTP_USERNAME_PROPERTY_KEY, SFTP_PASSWORD_PROPERTY_KEY, SFTP_SELECTED_SERVER_PROPERTY_KEY});
            }
            return builder.build();
        };
    }

    private Map<String, String> getEnvironmentProperties() {
        String providedProperties;
        HashMap<String, String> environmentProperties = new HashMap<String, String>();
        environmentProperties.put(DATASOURCE_URL_PROPERTY_KEY, this.sftpSourceTaskProperties.getDataSourceUrl());
        environmentProperties.put(DATASOURCE_USERNAME_PROPERTY_KEY, this.sftpSourceTaskProperties.getDataSourceUserName());
        environmentProperties.put(DATASOURCE_PASSWORD_PROPERTY_KEY, this.sftpSourceTaskProperties.getDataSourcePassword());
        if (!this.sftpSourceProperties.isMultiSource()) {
            environmentProperties.put(SFTP_HOST_PROPERTY_KEY, this.sftpSourceProperties.getFactory().getHost());
            environmentProperties.put(SFTP_USERNAME_PROPERTY_KEY, this.sftpSourceProperties.getFactory().getUsername());
            environmentProperties.put(SFTP_PASSWORD_PROPERTY_KEY, this.sftpSourceProperties.getFactory().getPassword());
            environmentProperties.put(SFTP_PORT_PROPERTY_KEY, String.valueOf(this.sftpSourceProperties.getFactory().getPort()));
        }
        if (StringUtils.hasText((String)(providedProperties = this.sftpSourceTaskProperties.getEnvironmentProperties()))) {
            String[] splitProperties = StringUtils.split((String)providedProperties, (String)",");
            Properties properties = StringUtils.splitArrayElementsIntoProperties((String[])splitProperties, (String)"=");
            for (String key : properties.stringPropertyNames()) {
                environmentProperties.put(key, properties.getProperty(key));
            }
        }
        return environmentProperties;
    }

    protected Map<String, String> getDeploymentProperties() {
        ArrayList<String> pairs = new ArrayList<String>();
        HashMap<String, String> deploymentProperties = new HashMap<String, String>();
        String properties = this.sftpSourceTaskProperties.getDeploymentProperties();
        String[] candidates = StringUtils.commaDelimitedListToStringArray((String)properties);
        for (int i = 0; i < candidates.length; ++i) {
            if (i > 0 && !candidates[i].contains("=")) {
                pairs.set(pairs.size() - 1, (String)pairs.get(pairs.size() - 1) + "," + candidates[i]);
                continue;
            }
            pairs.add(candidates[i]);
        }
        for (String pair : pairs) {
            this.addKeyValuePairAsProperty(pair, deploymentProperties);
        }
        return deploymentProperties;
    }

    private void addKeyValuePairAsProperty(String pair, Map<String, String> properties) {
        int firstEquals = pair.indexOf(61);
        if (firstEquals != -1) {
            properties.put(pair.substring(0, firstEquals).trim(), pair.substring(firstEquals + 1).trim());
        }
    }

    private List<String> getCommandLineArgs(Message<?> message) {
        Assert.notNull(message, (String)"Message from which to create TaskLaunchRequest cannot be null");
        String filename = (String)message.getPayload();
        String remoteDirectory = (String)message.getHeaders().get((Object)"file_remoteDirectory");
        String localFilePathJobParameterValue = this.sftpSourceTaskProperties.getLocalFilePathParameterValue();
        String remoteFilePath = remoteDirectory + filename;
        String localFilePath = localFilePathJobParameterValue + filename;
        String localFilePathJobParameterName = this.sftpSourceTaskProperties.getLocalFilePathParameterName();
        String remoteFilePathJobParameterName = this.sftpSourceTaskProperties.getRemoteFilePathParameterName();
        ArrayList<String> commandLineArgs = new ArrayList<String>();
        commandLineArgs.add(remoteFilePathJobParameterName + "=" + remoteFilePath);
        commandLineArgs.add(localFilePathJobParameterName + "=" + localFilePath);
        commandLineArgs.addAll(this.sftpSourceTaskProperties.getParameters());
        return commandLineArgs;
    }
}

