/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.sftp.source.task;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(value="sftp.task")
public class SftpSourceTaskProperties {
    public static final String DEFAULT_LOCAL_FILE_PATH_PARAM_NAME = "localFilePath";
    public static final String DEFAULT_REMOTE_FILE_PATH_PARAM_NAME = "remoteFilePath";
    private String resourceUri = "";
    private String dataSourceUrl = "jdbc:h2:tcp://localhost:19092/mem:dataflow";
    private String dataSourceUserName = "sa";
    private String dataSourcePassword;
    private String deploymentProperties;
    private String environmentProperties;
    private String remoteFilePathParameterName = "remoteFilePath";
    private String localFilePathParameterName = "localFilePath";
    private String localFilePathParameterValue = new File(System.getProperty("java.io.tmpdir")).getAbsolutePath();
    private List<String> parameters = new ArrayList<String>();
    private String applicationName;

    @NotNull
    public String getResourceUri() {
        return this.resourceUri;
    }

    public void setResourceUri(String resourceUri) {
        this.resourceUri = resourceUri;
    }

    @NotBlank
    public String getDataSourceUrl() {
        return this.dataSourceUrl;
    }

    public void setDataSourceUrl(String dataSourceUrl) {
        this.dataSourceUrl = dataSourceUrl;
    }

    @NotBlank
    public String getDataSourceUserName() {
        return this.dataSourceUserName;
    }

    public void setDataSourceUserName(String dataSourceUserName) {
        this.dataSourceUserName = dataSourceUserName;
    }

    public String getDataSourcePassword() {
        return this.dataSourcePassword;
    }

    public void setDataSourcePassword(String dataSourcePassword) {
        this.dataSourcePassword = dataSourcePassword;
    }

    public String getDeploymentProperties() {
        return this.deploymentProperties;
    }

    public void setDeploymentProperties(String deploymentProperties) {
        this.deploymentProperties = deploymentProperties;
    }

    public String getEnvironmentProperties() {
        return this.environmentProperties;
    }

    public void setEnvironmentProperties(String environmentProperties) {
        this.environmentProperties = environmentProperties;
    }

    public String getRemoteFilePathParameterName() {
        return this.remoteFilePathParameterName;
    }

    public void setRemoteFilePathParameterName(String remoteFilePathParameterName) {
        this.remoteFilePathParameterName = remoteFilePathParameterName;
    }

    public String getLocalFilePathParameterName() {
        return this.localFilePathParameterName;
    }

    public void setLocalFilePathParameterName(String localFilePathParameterName) {
        this.localFilePathParameterName = localFilePathParameterName;
    }

    @NotBlank
    public String getLocalFilePathParameterValue() {
        return this.localFilePathParameterValue;
    }

    public void setLocalFilePathParameterValue(String localFilePathParameterValue) {
        this.localFilePathParameterValue = localFilePathParameterValue;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<String> parameters) {
        this.parameters = parameters;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }
}

