/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.sftp.source.metadata;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.app.sftp.source.metadata.SftpSourceRedisIdempotentReceiverProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.integration.channel.NullChannel;
import org.springframework.integration.core.MessageSelector;
import org.springframework.integration.handler.ExpressionEvaluatingMessageProcessor;
import org.springframework.integration.handler.MessageProcessor;
import org.springframework.integration.handler.advice.IdempotentReceiverInterceptor;
import org.springframework.integration.metadata.ConcurrentMetadataStore;
import org.springframework.integration.redis.metadata.RedisMetadataStore;
import org.springframework.integration.selector.MetadataStoreSelector;
import org.springframework.messaging.MessageChannel;

@EnableConfigurationProperties(value={SftpSourceRedisIdempotentReceiverProperties.class, RedisProperties.class})
public class SftpSourceRedisIdempotentReceiverConfiguration {
    protected static final String REMOTE_DIRECTORY_MESSAGE_HEADER = "file_remoteDirectory";
    @Autowired
    private BeanFactory beanFactory;

    @Bean
    @ConditionalOnMissingBean
    public ConcurrentMetadataStore metadataStore(RedisConnectionFactory redisConnectionFactory, SftpSourceRedisIdempotentReceiverProperties sftpSourceRedisIdempotentReceiverProperties) {
        return new RedisMetadataStore(redisConnectionFactory, sftpSourceRedisIdempotentReceiverProperties.getKeyName());
    }

    @Bean
    @ConditionalOnMissingBean
    public IdempotentReceiverInterceptor idempotentReceiverInterceptor(ConcurrentMetadataStore metadataStore) {
        String expressionStatement = "headers['" + REMOTE_DIRECTORY_MESSAGE_HEADER + "'].concat(payload)";
        Expression expression = new SpelExpressionParser().parseExpression(expressionStatement);
        ExpressionEvaluatingMessageProcessor idempotentKeyStrategy = new ExpressionEvaluatingMessageProcessor(expression);
        idempotentKeyStrategy.setBeanFactory(this.beanFactory);
        IdempotentReceiverInterceptor idempotentReceiverInterceptor = new IdempotentReceiverInterceptor((MessageSelector)new MetadataStoreSelector((MessageProcessor)idempotentKeyStrategy, metadataStore));
        idempotentReceiverInterceptor.setDiscardChannel((MessageChannel)new NullChannel());
        return idempotentReceiverInterceptor;
    }
}

