/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.sftp.source;

import com.jcraft.jsch.ChannelSftp;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.app.file.FileConsumerProperties;
import org.springframework.cloud.stream.app.file.FileReadingMode;
import org.springframework.cloud.stream.app.file.FileUtils;
import org.springframework.cloud.stream.app.file.remote.RemoteFileDeletingTransactionSynchronizationProcessor;
import org.springframework.cloud.stream.app.sftp.source.SftpSourceProperties;
import org.springframework.cloud.stream.app.sftp.source.SftpSourceSessionFactoryConfiguration;
import org.springframework.cloud.stream.app.sftp.source.metadata.SftpSourceRedisIdempotentReceiverConfiguration;
import org.springframework.cloud.stream.app.sftp.source.tasklauncher.SftpSourceTaskLauncherConfiguration;
import org.springframework.cloud.stream.app.trigger.TriggerConfiguration;
import org.springframework.cloud.stream.app.trigger.TriggerPropertiesMaxMessagesDefaultUnlimited;
import org.springframework.cloud.stream.messaging.Source;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.integration.annotation.IdempotentReceiver;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.IntegrationFlows;
import org.springframework.integration.dsl.MessageHandlerSpec;
import org.springframework.integration.dsl.MessageSourceSpec;
import org.springframework.integration.dsl.SourcePollingChannelAdapterSpec;
import org.springframework.integration.file.filters.ChainFileListFilter;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.remote.RemoteFileTemplate;
import org.springframework.integration.file.remote.gateway.AbstractRemoteFileOutboundGateway;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.metadata.ConcurrentMetadataStore;
import org.springframework.integration.metadata.SimpleMetadataStore;
import org.springframework.integration.scheduling.PollerMetadata;
import org.springframework.integration.sftp.dsl.Sftp;
import org.springframework.integration.sftp.dsl.SftpInboundChannelAdapterSpec;
import org.springframework.integration.sftp.dsl.SftpStreamingInboundChannelAdapterSpec;
import org.springframework.integration.sftp.filters.SftpPersistentAcceptOnceFileListFilter;
import org.springframework.integration.sftp.filters.SftpRegexPatternFileListFilter;
import org.springframework.integration.sftp.filters.SftpSimplePatternFileListFilter;
import org.springframework.integration.sftp.session.SftpRemoteFileTemplate;
import org.springframework.integration.transaction.DefaultTransactionSynchronizationFactory;
import org.springframework.integration.transaction.PseudoTransactionManager;
import org.springframework.integration.transaction.TransactionSynchronizationFactory;
import org.springframework.integration.transaction.TransactionSynchronizationProcessor;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.MatchAlwaysTransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;
import org.springframework.util.Assert;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.StringUtils;

@EnableBinding(value={Source.class})
@EnableConfigurationProperties(value={SftpSourceProperties.class, FileConsumerProperties.class})
@Import(value={TriggerConfiguration.class, SftpSourceSessionFactoryConfiguration.class, TriggerPropertiesMaxMessagesDefaultUnlimited.class, SftpSourceRedisIdempotentReceiverConfiguration.class, SftpSourceTaskLauncherConfiguration.class})
public class SftpSourceConfiguration {
    @Autowired
    @Qualifier(value="defaultPoller")
    private PollerMetadata defaultPoller;
    @Autowired
    private Source source;
    @Autowired(required=false)
    private SftpRemoteFileTemplate sftpTemplate;
    @Autowired
    private SftpSourceProperties properties;

    @Bean
    public MessageChannel sftpFileListChannel() {
        return new DirectChannel();
    }

    @Bean
    public MessageChannel sftpFileTaskLaunchChannel() {
        return new DirectChannel();
    }

    @Bean
    public IntegrationFlow sftpInboundFlow(SessionFactory<ChannelSftp.LsEntry> sftpSessionFactory, FileConsumerProperties fileConsumerProperties) {
        IntegrationFlowBuilder flowBuilder;
        ChainFileListFilter filterChain = new ChainFileListFilter();
        if (StringUtils.hasText((String)this.properties.getFilenamePattern())) {
            filterChain.addFilter((FileListFilter)new SftpSimplePatternFileListFilter(this.properties.getFilenamePattern()));
        } else if (this.properties.getFilenameRegex() != null) {
            filterChain.addFilter((FileListFilter)new SftpRegexPatternFileListFilter(this.properties.getFilenameRegex()));
        }
        filterChain.addFilter((FileListFilter)new SftpPersistentAcceptOnceFileListFilter((ConcurrentMetadataStore)new SimpleMetadataStore(), "sftpSource"));
        if (this.properties.isStream()) {
            SftpStreamingInboundChannelAdapterSpec messageSourceStreamingSpec = (SftpStreamingInboundChannelAdapterSpec)((SftpStreamingInboundChannelAdapterSpec)((SftpStreamingInboundChannelAdapterSpec)Sftp.inboundStreamingAdapter((RemoteFileTemplate)this.sftpTemplate).remoteDirectory(this.properties.getRemoteDir())).remoteFileSeparator(this.properties.getRemoteFileSeparator())).filter((FileListFilter)filterChain);
            flowBuilder = FileUtils.enhanceStreamFlowForReadingMode((IntegrationFlowBuilder)IntegrationFlows.from((MessageSourceSpec)messageSourceStreamingSpec, this.properties.isDeleteRemoteFiles() ? this.consumerSpecWithDelete() : this.consumerSpec()), (FileConsumerProperties)fileConsumerProperties);
        } else {
            if (this.properties.isListOnly() || this.properties.isTaskLauncherOutput()) {
                return ((IntegrationFlowBuilder)((IntegrationFlowBuilder)((IntegrationFlowBuilder)IntegrationFlows.from(() -> this.properties.getRemoteDir(), this.consumerSpec()).handle((MessageHandlerSpec)Sftp.outboundGateway(sftpSessionFactory, (String)AbstractRemoteFileOutboundGateway.Command.LS.getCommand(), (String)"payload").options(AbstractRemoteFileOutboundGateway.Option.NAME_ONLY.getOption()))).split()).channel(this.properties.isListOnly() ? this.sftpFileListChannel() : this.sftpFileTaskLaunchChannel())).get();
            }
            SftpInboundChannelAdapterSpec messageSourceBuilder = (SftpInboundChannelAdapterSpec)((SftpInboundChannelAdapterSpec)((SftpInboundChannelAdapterSpec)((SftpInboundChannelAdapterSpec)((SftpInboundChannelAdapterSpec)((SftpInboundChannelAdapterSpec)((SftpInboundChannelAdapterSpec)Sftp.inboundAdapter(sftpSessionFactory).preserveTimestamp(this.properties.isPreserveTimestamp())).remoteDirectory(this.properties.getRemoteDir())).remoteFileSeparator(this.properties.getRemoteFileSeparator())).localDirectory(this.properties.getLocalDir())).autoCreateLocalDirectory(this.properties.isAutoCreateLocalDir())).temporaryFileSuffix(this.properties.getTmpFileSuffix())).deleteRemoteFiles(this.properties.isDeleteRemoteFiles());
            messageSourceBuilder.filter((FileListFilter)filterChain);
            flowBuilder = IntegrationFlows.from((MessageSourceSpec)messageSourceBuilder, this.consumerSpec());
            if (fileConsumerProperties.getMode() != FileReadingMode.ref) {
                flowBuilder = FileUtils.enhanceFlowForReadingMode((IntegrationFlowBuilder)flowBuilder, (FileConsumerProperties)fileConsumerProperties);
            }
        }
        return ((IntegrationFlowBuilder)flowBuilder.channel(this.source.output())).get();
    }

    private Consumer<SourcePollingChannelAdapterSpec> consumerSpec() {
        return spec -> spec.poller(this.defaultPoller);
    }

    private Consumer<SourcePollingChannelAdapterSpec> consumerSpecWithDelete() {
        PollerMetadata poller = new PollerMetadata();
        BeanUtils.copyProperties((Object)this.defaultPoller, (Object)poller, (String[])new String[]{"transactionSynchronizationFactory"});
        RemoteFileDeletingTransactionSynchronizationProcessor processor = new RemoteFileDeletingTransactionSynchronizationProcessor((RemoteFileTemplate)this.sftpTemplate, this.properties.getRemoteFileSeparator());
        poller.setTransactionSynchronizationFactory((TransactionSynchronizationFactory)new DefaultTransactionSynchronizationFactory((TransactionSynchronizationProcessor)processor));
        poller.setAdviceChain(Collections.singletonList(new TransactionInterceptor((PlatformTransactionManager)new PseudoTransactionManager(), (TransactionAttributeSource)new MatchAlwaysTransactionAttributeSource())));
        return spec -> spec.poller(poller);
    }

    @Bean
    @ConditionalOnProperty(name={"sftp.stream"})
    public SftpRemoteFileTemplate sftpTemplate(SessionFactory<ChannelSftp.LsEntry> sftpSessionFactory) {
        return new SftpRemoteFileTemplate(sftpSessionFactory);
    }

    @ConditionalOnProperty(name={"sftp.listOnly"})
    @IdempotentReceiver(value={"idempotentReceiverInterceptor"})
    @ServiceActivator(inputChannel="sftpFileListChannel", outputChannel="output")
    public Message transformSftpMessage(Message message) {
        MessageHeaders messageHeaders = message.getHeaders();
        Assert.notNull((Object)messageHeaders, (String)"Cannot transform message with null headers");
        Assert.isTrue((boolean)messageHeaders.containsKey((Object)"file_remoteDirectory"), (String)"Remote directory header not found");
        String fileName = (String)message.getPayload();
        Assert.hasText((String)fileName, (String)"Filename in payload cannot be empty");
        String fileDir = (String)messageHeaders.get((Object)"file_remoteDirectory");
        String outboundPayload = fileDir + fileName;
        return MessageBuilder.withPayload((Object)outboundPayload).copyHeaders((Map)messageHeaders).setHeader("contentType", (Object)MimeTypeUtils.TEXT_PLAIN).build();
    }
}

