/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.sftp.source;

import com.jcraft.jsch.ChannelSftp;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.app.file.FileConsumerProperties;
import org.springframework.cloud.stream.app.file.FileUtils;
import org.springframework.cloud.stream.app.sftp.SftpSessionFactoryConfiguration;
import org.springframework.cloud.stream.app.sftp.source.SftpSourceProperties;
import org.springframework.cloud.stream.app.trigger.TriggerConfiguration;
import org.springframework.cloud.stream.app.trigger.TriggerPropertiesMaxMessagesDefaultUnlimited;
import org.springframework.cloud.stream.messaging.Source;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.IntegrationFlows;
import org.springframework.integration.dsl.SourcePollingChannelAdapterSpec;
import org.springframework.integration.dsl.core.MessageSourceSpec;
import org.springframework.integration.dsl.sftp.Sftp;
import org.springframework.integration.dsl.sftp.SftpInboundChannelAdapterSpec;
import org.springframework.integration.dsl.support.Consumer;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.scheduling.PollerMetadata;
import org.springframework.integration.sftp.filters.SftpRegexPatternFileListFilter;
import org.springframework.integration.sftp.filters.SftpSimplePatternFileListFilter;
import org.springframework.util.StringUtils;

@EnableBinding(value={Source.class})
@EnableConfigurationProperties(value={SftpSourceProperties.class, FileConsumerProperties.class})
@Import(value={TriggerConfiguration.class, SftpSessionFactoryConfiguration.class, TriggerPropertiesMaxMessagesDefaultUnlimited.class})
public class SftpSourceConfiguration {
    @Autowired
    @Qualifier(value="defaultPoller")
    PollerMetadata defaultPoller;
    @Autowired
    Source source;

    @Bean
    public IntegrationFlow sftpInboundFlow(SessionFactory<ChannelSftp.LsEntry> sftpSessionFactory, SftpSourceProperties properties, FileConsumerProperties fileConsumerProperties) {
        SftpInboundChannelAdapterSpec messageSourceBuilder = (SftpInboundChannelAdapterSpec)((SftpInboundChannelAdapterSpec)((SftpInboundChannelAdapterSpec)((SftpInboundChannelAdapterSpec)((SftpInboundChannelAdapterSpec)((SftpInboundChannelAdapterSpec)((SftpInboundChannelAdapterSpec)Sftp.inboundAdapter(sftpSessionFactory).preserveTimestamp(properties.isPreserveTimestamp())).remoteDirectory(properties.getRemoteDir())).remoteFileSeparator(properties.getRemoteFileSeparator())).localDirectory(properties.getLocalDir())).autoCreateLocalDirectory(properties.isAutoCreateLocalDir())).temporaryFileSuffix(properties.getTmpFileSuffix())).deleteRemoteFiles(properties.isDeleteRemoteFiles());
        if (StringUtils.hasText((String)properties.getFilenamePattern())) {
            messageSourceBuilder.filter((FileListFilter)new SftpSimplePatternFileListFilter(properties.getFilenamePattern()));
        } else if (properties.getFilenameRegex() != null) {
            messageSourceBuilder.filter((FileListFilter)new SftpRegexPatternFileListFilter(properties.getFilenameRegex()));
        }
        IntegrationFlowBuilder flowBuilder = IntegrationFlows.from((MessageSourceSpec)messageSourceBuilder, (Consumer)new Consumer<SourcePollingChannelAdapterSpec>(){

            public void accept(SourcePollingChannelAdapterSpec sourcePollingChannelAdapterSpec) {
                sourcePollingChannelAdapterSpec.poller(SftpSourceConfiguration.this.defaultPoller);
            }
        });
        return ((IntegrationFlowBuilder)FileUtils.enhanceFlowForReadingMode((IntegrationFlowBuilder)flowBuilder, (FileConsumerProperties)fileConsumerProperties).channel(this.source.output())).get();
    }
}

