/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.s3.source;

import com.amazonaws.services.s3.AmazonS3;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.aws.core.env.ResourceIdResolver;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.app.file.FileConsumerProperties;
import org.springframework.cloud.stream.app.file.FileUtils;
import org.springframework.cloud.stream.app.s3.AmazonS3Configuration;
import org.springframework.cloud.stream.app.s3.source.AmazonS3SourceProperties;
import org.springframework.cloud.stream.app.trigger.TriggerConfiguration;
import org.springframework.cloud.stream.app.trigger.TriggerPropertiesMaxMessagesDefaultUnlimited;
import org.springframework.cloud.stream.messaging.Source;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.integration.aws.inbound.S3InboundFileSynchronizer;
import org.springframework.integration.aws.inbound.S3InboundFileSynchronizingMessageSource;
import org.springframework.integration.aws.support.S3SessionFactory;
import org.springframework.integration.aws.support.filters.S3RegexPatternFileListFilter;
import org.springframework.integration.aws.support.filters.S3SimplePatternFileListFilter;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.IntegrationFlows;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.file.remote.synchronizer.AbstractInboundFileSynchronizer;
import org.springframework.util.StringUtils;

@EnableBinding(value={Source.class})
@EnableConfigurationProperties(value={AmazonS3SourceProperties.class, FileConsumerProperties.class, TriggerPropertiesMaxMessagesDefaultUnlimited.class})
@Import(value={TriggerConfiguration.class, AmazonS3Configuration.class})
public class AmazonS3SourceConfiguration {
    @Autowired
    private AmazonS3SourceProperties s3SourceProperties;

    @Bean
    public S3InboundFileSynchronizer s3InboundFileSynchronizer(AmazonS3 amazonS3, ResourceIdResolver resourceIdResolver) {
        S3SessionFactory s3SessionFactory = new S3SessionFactory(amazonS3, resourceIdResolver);
        S3InboundFileSynchronizer synchronizer = new S3InboundFileSynchronizer((SessionFactory)s3SessionFactory);
        synchronizer.setDeleteRemoteFiles(this.s3SourceProperties.isDeleteRemoteFiles());
        synchronizer.setPreserveTimestamp(this.s3SourceProperties.isPreserveTimestamp());
        String remoteDir = this.s3SourceProperties.getRemoteDir();
        synchronizer.setRemoteDirectory(remoteDir);
        synchronizer.setRemoteFileSeparator(this.s3SourceProperties.getRemoteFileSeparator());
        synchronizer.setTemporaryFileSuffix(this.s3SourceProperties.getTmpFileSuffix());
        if (StringUtils.hasText((String)this.s3SourceProperties.getFilenamePattern())) {
            synchronizer.setFilter((FileListFilter)new S3SimplePatternFileListFilter(this.s3SourceProperties.getFilenamePattern()));
        } else if (this.s3SourceProperties.getFilenameRegex() != null) {
            synchronizer.setFilter((FileListFilter)new S3RegexPatternFileListFilter(this.s3SourceProperties.getFilenameRegex()));
        }
        return synchronizer;
    }

    @Bean
    public IntegrationFlow s3InboundFlow(FileConsumerProperties fileConsumerProperties, S3InboundFileSynchronizer s3InboundFileSynchronizer) {
        S3InboundFileSynchronizingMessageSource s3MessageSource = new S3InboundFileSynchronizingMessageSource((AbstractInboundFileSynchronizer)s3InboundFileSynchronizer);
        s3MessageSource.setLocalDirectory(this.s3SourceProperties.getLocalDir());
        s3MessageSource.setAutoCreateLocalDirectory(this.s3SourceProperties.isAutoCreateLocalDir());
        return ((IntegrationFlowBuilder)FileUtils.enhanceFlowForReadingMode((IntegrationFlowBuilder)IntegrationFlows.from((MessageSource)s3MessageSource), (FileConsumerProperties)fileConsumerProperties).channel("output")).get();
    }
}

