/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.rabbit.source;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Envelope;
import org.aopalliance.aop.Advice;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.config.RetryInterceptorBuilder;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionNameStrategy;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.amqp.rabbit.retry.MessageRecoverer;
import org.springframework.amqp.rabbit.retry.RejectAndDontRequeueRecoverer;
import org.springframework.amqp.rabbit.support.DefaultMessagePropertiesConverter;
import org.springframework.amqp.rabbit.support.MessagePropertiesConverter;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.app.rabbit.source.AutoConfig;
import org.springframework.cloud.stream.app.rabbit.source.RabbitSourceProperties;
import org.springframework.cloud.stream.messaging.Source;
import org.springframework.context.annotation.Bean;
import org.springframework.integration.amqp.dsl.Amqp;
import org.springframework.integration.amqp.dsl.AmqpInboundChannelAdapterSMLCSpec;
import org.springframework.integration.amqp.inbound.AmqpInboundChannelAdapter;
import org.springframework.retry.interceptor.RetryOperationsInterceptor;
import org.springframework.util.Assert;

@EnableBinding(value={Source.class})
@EnableConfigurationProperties(value={RabbitSourceProperties.class})
public class RabbitSourceConfiguration
implements DisposableBean {
    private static final MessagePropertiesConverter inboundMessagePropertiesConverter = new DefaultMessagePropertiesConverter(){

        public MessageProperties toMessageProperties(AMQP.BasicProperties source, Envelope envelope, String charset) {
            MessageProperties properties = super.toMessageProperties(source, envelope, charset);
            properties.setDeliveryMode(null);
            return properties;
        }
    };
    @Autowired
    private Source channels;
    @Autowired
    private RabbitProperties rabbitProperties;
    @Autowired
    private ObjectProvider<ConnectionNameStrategy> connectionNameStrategy;
    @Autowired
    private RabbitSourceProperties properties;
    @Autowired
    private ConnectionFactory rabbitConnectionFactory;
    private CachingConnectionFactory ownConnectionFactory;

    @Bean
    public SimpleMessageListenerContainer container() throws Exception {
        Integer transactionSize;
        Integer prefetch;
        Integer maxConcurrency;
        Integer concurrency;
        ConnectionFactory connectionFactory = this.properties.isOwnConnection() ? this.buildLocalConnectionFactory() : this.rabbitConnectionFactory;
        SimpleMessageListenerContainer container = new SimpleMessageListenerContainer(connectionFactory);
        RabbitProperties.SimpleContainer simpleContainer = this.rabbitProperties.getListener().getSimple();
        AcknowledgeMode acknowledgeMode = simpleContainer.getAcknowledgeMode();
        if (acknowledgeMode != null) {
            container.setAcknowledgeMode(acknowledgeMode);
        }
        if ((concurrency = simpleContainer.getConcurrency()) != null) {
            container.setConcurrentConsumers(concurrency.intValue());
        }
        if ((maxConcurrency = simpleContainer.getMaxConcurrency()) != null) {
            container.setMaxConcurrentConsumers(maxConcurrency.intValue());
        }
        if ((prefetch = simpleContainer.getPrefetch()) != null) {
            container.setPrefetchCount(prefetch.intValue());
        }
        if ((transactionSize = simpleContainer.getTransactionSize()) != null) {
            container.setTxSize(transactionSize.intValue());
        }
        container.setDefaultRequeueRejected(this.properties.getRequeue());
        container.setChannelTransacted(this.properties.getTransacted());
        Object[] queues = this.properties.getQueues();
        Assert.state((queues.length > 0 ? 1 : 0) != 0, (String)"At least one queue is required");
        Assert.noNullElements((Object[])queues, (String)"queues cannot have null elements");
        container.setQueueNames((String[])queues);
        if (this.properties.isEnableRetry()) {
            container.setAdviceChain(new Advice[]{this.rabbitSourceRetryInterceptor()});
        }
        container.setMessagePropertiesConverter(inboundMessagePropertiesConverter);
        return container;
    }

    private ConnectionFactory buildLocalConnectionFactory() throws Exception {
        this.ownConnectionFactory = new AutoConfig.Creator().rabbitConnectionFactory(this.rabbitProperties, this.connectionNameStrategy);
        return this.ownConnectionFactory;
    }

    @Bean
    public AmqpInboundChannelAdapter adapter() throws Exception {
        return (AmqpInboundChannelAdapter)((AmqpInboundChannelAdapterSMLCSpec)((AmqpInboundChannelAdapterSMLCSpec)Amqp.inboundAdapter((SimpleMessageListenerContainer)this.container()).outputChannel(this.channels.output())).mappedRequestHeaders(this.properties.getMappedRequestHeaders())).get();
    }

    @Bean
    public RetryOperationsInterceptor rabbitSourceRetryInterceptor() {
        return (RetryOperationsInterceptor)RetryInterceptorBuilder.stateless().maxAttempts(this.properties.getMaxAttempts()).backOffOptions((long)this.properties.getInitialRetryInterval(), this.properties.getRetryMultiplier(), (long)this.properties.getMaxRetryInterval()).recoverer((MessageRecoverer)new RejectAndDontRequeueRecoverer()).build();
    }

    public void destroy() throws Exception {
        if (this.ownConnectionFactory != null) {
            this.ownConnectionFactory.destroy();
        }
    }
}

